/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest.pipeline;

import com.coravy.hudson.plugins.github.GithubProjectProperty;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import hudson.AbortException;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Objects;
import jenkins.model.JenkinsLocationConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRCause;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRTrigger;
import org.jenkinsci.plugins.github.pullrequest.pipeline.SetCommitStatusStep;
import org.jenkinsci.plugins.github.pullrequest.utils.JobHelper;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.github.GHRepository;

public class SetCommitStatusExecution
extends AbstractSynchronousNonBlockingStepExecution<Void> {
    private static final long serialVersionUID = 1L;
    @StepContextParameter
    private transient Run<?, ?> run;
    @StepContextParameter
    private transient TaskListener log;
    @Inject
    private transient SetCommitStatusStep config;

    protected Void run() throws Exception {
        Preconditions.checkArgument((boolean)Objects.nonNull(this.config.getState()), (Object)"Missing required parameter 'state'");
        GHRepository repository = this.resolveRepository();
        String statusContext = this.resolveContext();
        GitHubPRCause cause = (GitHubPRCause)this.run.getCause(GitHubPRCause.class);
        if (Objects.isNull((Object)cause)) {
            throw new AbortException("setGitHubPullRequestStatus requires run to be triggered by GitHub Pull Request");
        }
        this.log.getLogger().printf("Setting pull request status %s to %s with message: %s%n", statusContext, this.config.getState(), this.config.getMessage());
        Object buildUrl = null;
        JenkinsLocationConfiguration globalConfig = JenkinsLocationConfiguration.get();
        if (Objects.nonNull(globalConfig)) {
            buildUrl = globalConfig.getUrl();
        }
        if (StringUtils.isEmpty(buildUrl)) {
            this.log.error("Jenkins Location is not configured in system settings. Cannot create a 'details' link.");
            buildUrl = null;
        } else {
            buildUrl = (String)buildUrl + this.run.getUrl();
        }
        repository.createCommitStatus(cause.getHeadSha(), this.config.getState(), (String)buildUrl, this.config.getMessage(), statusContext);
        return null;
    }

    private GHRepository resolveRepository() throws IOException {
        try {
            GitHubPRTrigger trigger = JobHelper.ghPRTriggerFromRun(this.run);
            if (trigger != null) {
                return trigger.getRemoteRepository();
            }
            throw new AbortException("GitHub PullRequest trigger isn't available.");
        }
        catch (Exception e) {
            this.log.error("pullRequest: GitHub repository not configured for project?");
            throw e;
        }
    }

    private String resolveContext() {
        if (StringUtils.isNotBlank((CharSequence)this.config.getContext())) {
            return this.config.getContext();
        }
        GithubProjectProperty githubProperty = (GithubProjectProperty)this.run.getParent().getProperty(GithubProjectProperty.class);
        if (Objects.isNull(githubProperty) || StringUtils.isBlank((CharSequence)githubProperty.getDisplayName())) {
            this.log.error("Unable to determine commit status context (the check name). Argument 'context' not provided and no default configured. Using job name as fallback.");
            return this.run.getParent().getFullName();
        }
        return githubProperty.getDisplayName();
    }
}

