/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest.extra;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Cause;
import hudson.model.Job;
import hudson.model.Queue;
import java.util.List;
import java.util.Set;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.blockqueuedjob.condition.BlockQueueCondition;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRCause;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRLabel;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubPRLabelUnblockQueueCondition
extends BlockQueueCondition {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHubPRLabelUnblockQueueCondition.class);
    private GitHubPRLabel label;

    @DataBoundConstructor
    public GitHubPRLabelUnblockQueueCondition(GitHubPRLabel label) {
        this.label = label;
    }

    public GitHubPRLabel getLabel() {
        return this.label;
    }

    public boolean isUnblocked(Queue.Item item) {
        List causes = item.getCauses();
        for (Cause cause : causes) {
            if (!(cause instanceof GitHubPRCause)) continue;
            GitHubPRCause gitHubPRCause = (GitHubPRCause)cause;
            Set<String> causeLabels = gitHubPRCause.getLabels();
            if (this.getLabel() == null || !causeLabels.containsAll(this.label.getLabelsSet())) continue;
            if (item.task instanceof Job) {
                Job job = (Job)item.task;
                LOGGER.debug("Unblocking job item {} with matched labels {}", (Object)job.getFullName(), this.label.getLabelsSet());
            }
            return true;
        }
        return false;
    }

    @Symbol(value={"unblockGitHubPRLabel"})
    @Extension(optional=true)
    public static class DescriptorImpl
    extends BlockQueueCondition.BlockQueueConditionDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Unblock when GitHub PR label exists";
        }
    }
}

