/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest.events.impl;

import com.github.kostyasha.github.integration.generic.GitHubPRDecisionContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Objects;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRCause;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRPullRequest;
import org.jenkinsci.plugins.github.pullrequest.events.GitHubPREvent;
import org.jenkinsci.plugins.github.pullrequest.events.GitHubPREventDescriptor;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubPROpenEvent
extends GitHubPREvent {
    private static final String DISPLAY_NAME = "Pull Request Opened";
    private static final Logger LOG = LoggerFactory.getLogger(GitHubPROpenEvent.class);

    @DataBoundConstructor
    public GitHubPROpenEvent() {
    }

    @Override
    public GitHubPRCause check(@NonNull GitHubPRDecisionContext prDecisionContext) throws IOException {
        TaskListener listener = prDecisionContext.getListener();
        GitHubPRPullRequest localPR = prDecisionContext.getLocalPR();
        GHPullRequest remotePR = prDecisionContext.getRemotePR();
        if (remotePR.getState() == GHIssueState.CLOSED) {
            return null;
        }
        GitHubPRCause cause = null;
        String causeMessage = "PR opened";
        if (Objects.isNull(localPR)) {
            PrintStream logger = listener.getLogger();
            logger.println("Pull Request Opened: state has changed (PR was opened)");
            cause = prDecisionContext.newCause(causeMessage, false);
        }
        return cause;
    }

    @Symbol(value={"Open"})
    @Extension
    public static class DescriptorImpl
    extends GitHubPREventDescriptor {
        @NonNull
        public final String getDisplayName() {
            return GitHubPROpenEvent.DISPLAY_NAME;
        }
    }
}

