/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest.events.impl;

import com.github.kostyasha.github.integration.generic.GitHubPRDecisionContext;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Objects;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRCause;
import org.jenkinsci.plugins.github.pullrequest.events.GitHubPREvent;
import org.jenkinsci.plugins.github.pullrequest.events.GitHubPREventDescriptor;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.stapler.DataBoundConstructor;

public class GitHubPRNumber
extends GitHubPREvent {
    private static final String DISPLAY_NAME = "PR Number";
    private boolean skip;
    private Integer number;
    private boolean match;

    @DataBoundConstructor
    public GitHubPRNumber(Integer number, boolean match, boolean skip) {
        this.number = number;
        this.match = match;
        this.skip = skip;
    }

    @CheckForNull
    public Integer getNumber() {
        return this.number;
    }

    public boolean isMatch() {
        return this.match;
    }

    public boolean isSkip() {
        return this.skip;
    }

    @Override
    public GitHubPRCause check(@NonNull GitHubPRDecisionContext prDecisionContext) throws IOException {
        TaskListener listener = prDecisionContext.getListener();
        GHPullRequest remotePR = prDecisionContext.getRemotePR();
        if (Objects.isNull(this.number)) {
            listener.error("PR Number: number is null -> Bad configured event, skipping other checks.");
            return prDecisionContext.newCause("Bad configured PR Number event.", true);
        }
        if (Objects.isNull(remotePR)) {
            listener.error("PR Number: number is null -> Bad configured event, skipping other checks.");
            return prDecisionContext.newCause("Bad configured PR Number event.", true);
        }
        if (remotePR.getNumber() == this.getNumber().intValue()) {
            if (this.match) {
                return prDecisionContext.newCause("PR Number is matching #" + remotePR.getNumber(), this.isSkip());
            }
        } else if (!this.match) {
            return prDecisionContext.newCause("PR Number is not matching #" + remotePR.getNumber(), this.isSkip());
        }
        return null;
    }

    @Symbol(value={"Number"})
    @Extension
    public static class DescriptorImpl
    extends GitHubPREventDescriptor {
        @NonNull
        public String getDisplayName() {
            return GitHubPRNumber.DISPLAY_NAME;
        }
    }
}

