/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest.events.impl;

import com.github.kostyasha.github.integration.generic.GitHubPRDecisionContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRCause;
import org.jenkinsci.plugins.github.pullrequest.events.GitHubPREvent;
import org.jenkinsci.plugins.github.pullrequest.events.GitHubPREventDescriptor;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubPRNonMergeableEvent
extends GitHubPREvent {
    private static final String DISPLAY_NAME = "Not mergeable";
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHubPRNonMergeableEvent.class);
    private boolean skip = true;

    @DataBoundConstructor
    public GitHubPRNonMergeableEvent(boolean skip) {
        this.skip = skip;
    }

    @Override
    public GitHubPRCause check(@NonNull GitHubPRDecisionContext prDecisionContext) throws IOException {
        Boolean mergeable;
        TaskListener listener = prDecisionContext.getListener();
        GHPullRequest remotePR = prDecisionContext.getRemotePR();
        PrintStream logger = listener.getLogger();
        try {
            mergeable = remotePR.getMergeable();
        }
        catch (IOException e) {
            listener.error("Not mergeable: can't get mergeable status {}", new Object[]{e});
            LOGGER.warn("Can't get mergeable status: {}", (Throwable)e);
            mergeable = false;
        }
        mergeable = mergeable != null ? mergeable : false;
        if (!mergeable.booleanValue()) {
            return prDecisionContext.newCause(DISPLAY_NAME, this.isSkip());
        }
        return null;
    }

    public boolean isSkip() {
        return this.skip;
    }

    @Symbol(value={"nonMergeable"})
    @Extension
    public static class DescriptorImpl
    extends GitHubPREventDescriptor {
        @NonNull
        public String getDisplayName() {
            return GitHubPRNonMergeableEvent.DISPLAY_NAME;
        }
    }
}

