/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest.events.impl;

import com.github.kostyasha.github.integration.generic.GitHubPRDecisionContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Objects;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRCause;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRLabel;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRPullRequest;
import org.jenkinsci.plugins.github.pullrequest.events.GitHubPREvent;
import org.jenkinsci.plugins.github.pullrequest.events.GitHubPREventDescriptor;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHLabel;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubPRLabelRemovedEvent
extends GitHubPREvent {
    private static final Logger LOG = LoggerFactory.getLogger(GitHubPRLabelRemovedEvent.class);
    private static final String DISPLAY_NAME = "Labels removed";
    private final GitHubPRLabel label;

    @DataBoundConstructor
    public GitHubPRLabelRemovedEvent(GitHubPRLabel label) {
        this.label = label;
    }

    @Override
    public GitHubPRCause check(@NonNull GitHubPRDecisionContext prDecisionContext) throws IOException {
        TaskListener listener = prDecisionContext.getListener();
        GitHubPRPullRequest localPR = prDecisionContext.getLocalPR();
        GHPullRequest remotePR = prDecisionContext.getRemotePR();
        if (remotePR.getState().equals((Object)GHIssueState.CLOSED)) {
            return null;
        }
        if (Objects.isNull(localPR)) {
            return null;
        }
        boolean hasLocal = false;
        for (String l : localPR.getLabels()) {
            for (String string : this.label.getLabelsSet()) {
                if (!string.equals(l)) continue;
                hasLocal = true;
                break;
            }
            if (!hasLocal) continue;
            break;
        }
        GitHubPRCause cause = null;
        boolean hasRemote = false;
        Collection labels = remotePR.getRepository().getIssue(remotePR.getNumber()).getLabels();
        for (GHLabel remoteLabel : labels) {
            for (String checkedLabel : this.label.getLabelsSet()) {
                if (!checkedLabel.equals(remoteLabel.getName())) continue;
                hasRemote = true;
                break;
            }
            if (!hasRemote) continue;
            break;
        }
        if (hasLocal && !hasRemote) {
            PrintStream printStream = listener.getLogger();
            printStream.println("Labels removed: state has changed (" + String.valueOf(this.label.getLabelsSet()) + " labels were removed)");
            cause = prDecisionContext.newCause(String.valueOf(this.label.getLabelsSet()) + " labels were removed", false);
        }
        return cause;
    }

    public GitHubPRLabel getLabel() {
        return this.label;
    }

    @Symbol(value={"labelsRemoved"})
    @Extension
    public static class DescriptorImpl
    extends GitHubPREventDescriptor {
        @NonNull
        public String getDisplayName() {
            return GitHubPRLabelRemovedEvent.DISPLAY_NAME;
        }
    }
}

