/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest.events.impl;

import com.github.kostyasha.github.integration.generic.GitHubPRDecisionContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.regex.Pattern;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRCause;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRLabel;
import org.jenkinsci.plugins.github.pullrequest.events.GitHubPREvent;
import org.jenkinsci.plugins.github.pullrequest.events.GitHubPREventDescriptor;
import org.kohsuke.github.GHLabel;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubPRLabelPatternExistsEvent
extends GitHubPREvent {
    private static final String DISPLAY_NAME = "Labels matched to patterns";
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHubPRLabelPatternExistsEvent.class);
    private final GitHubPRLabel label;
    private boolean skip = true;

    @DataBoundConstructor
    public GitHubPRLabelPatternExistsEvent(GitHubPRLabel label, boolean skip) {
        this.label = label;
        this.skip = skip;
    }

    @Override
    public GitHubPRCause check(@NonNull GitHubPRDecisionContext prDecisionContext) throws IOException {
        TaskListener listener = prDecisionContext.getListener();
        GHPullRequest remotePR = prDecisionContext.getRemotePR();
        PrintStream logger = listener.getLogger();
        for (GHLabel ghLabel : remotePR.getRepository().getIssue(remotePR.getNumber()).getLabels()) {
            for (String labelPatternStr : this.label.getLabelsSet()) {
                Pattern labelPattern = Pattern.compile(labelPatternStr);
                if (!labelPattern.matcher(ghLabel.getName()).matches()) continue;
                logger.println("Labels matched to patterns: Pull request has label: " + labelPatternStr);
                LOGGER.info("Pull request has '{}' label.", (Object)labelPatternStr);
                return prDecisionContext.newCause("PR has label: " + labelPatternStr, this.isSkip());
            }
        }
        return null;
    }

    public GitHubPRLabel getLabel() {
        return this.label;
    }

    public boolean isSkip() {
        return this.skip;
    }

    @Symbol(value={"labelsPatternExists"})
    @Extension
    public static class DescriptorImpl
    extends GitHubPREventDescriptor {
        @NonNull
        public String getDisplayName() {
            return GitHubPRLabelPatternExistsEvent.DISPLAY_NAME;
        }
    }
}

