/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest.events.impl;

import com.github.kostyasha.github.integration.generic.GitHubPRDecisionContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashSet;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRCause;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRLabel;
import org.jenkinsci.plugins.github.pullrequest.events.GitHubPREvent;
import org.jenkinsci.plugins.github.pullrequest.events.GitHubPREventDescriptor;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHLabel;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubPRLabelNotExistsEvent
extends GitHubPREvent {
    private static final String DISPLAY_NAME = "Labels not exist";
    private static final Logger LOG = LoggerFactory.getLogger(GitHubPRLabelNotExistsEvent.class);
    private final GitHubPRLabel label;
    private boolean skip = true;

    @DataBoundConstructor
    public GitHubPRLabelNotExistsEvent(GitHubPRLabel label, boolean skip) {
        this.label = label;
        this.skip = skip;
    }

    @Override
    public GitHubPRCause check(@NonNull GitHubPRDecisionContext prDecisionContext) throws IOException {
        TaskListener listener = prDecisionContext.getListener();
        GHPullRequest remotePR = prDecisionContext.getRemotePR();
        if (remotePR.getState().equals((Object)GHIssueState.CLOSED)) {
            return null;
        }
        GitHubPRCause cause = null;
        Collection remoteLabels = remotePR.getRepository().getIssue(remotePR.getNumber()).getLabels();
        HashSet<String> existingLabels = new HashSet<String>();
        for (GHLabel ghLabel : remoteLabels) {
            existingLabels.add(ghLabel.getName());
        }
        existingLabels.retainAll(this.label.getLabelsSet());
        if (existingLabels.isEmpty()) {
            PrintStream logger = listener.getLogger();
            LOG.debug("{}:{} not found", (Object)DISPLAY_NAME, this.label.getLabelsSet());
            logger.println("Labels not exist: " + String.valueOf(this.label.getLabelsSet()) + " not found");
            cause = prDecisionContext.newCause(String.valueOf(this.label.getLabelsSet()) + " labels not exist", this.isSkip());
        }
        return cause;
    }

    public GitHubPRLabel getLabel() {
        return this.label;
    }

    public boolean isSkip() {
        return this.skip;
    }

    @Symbol(value={"labelsNotExist"})
    @Extension
    public static class DescriptorImpl
    extends GitHubPREventDescriptor {
        @NonNull
        public String getDisplayName() {
            return GitHubPRLabelNotExistsEvent.DISPLAY_NAME;
        }
    }
}

