/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest.events.impl;

import com.github.kostyasha.github.integration.generic.GitHubPRDecisionContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashSet;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRCause;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRLabel;
import org.jenkinsci.plugins.github.pullrequest.events.GitHubPREvent;
import org.jenkinsci.plugins.github.pullrequest.events.GitHubPREventDescriptor;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHLabel;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubPRLabelExistsEvent
extends GitHubPREvent {
    private static final String DISPLAY_NAME = "Labels exist";
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHubPRLabelExistsEvent.class);
    private final GitHubPRLabel label;
    private boolean skip = true;

    @DataBoundConstructor
    public GitHubPRLabelExistsEvent(GitHubPRLabel label, boolean skip) {
        this.label = label;
        this.skip = skip;
    }

    @Override
    public GitHubPRCause check(@NonNull GitHubPRDecisionContext prDecisionContext) throws IOException {
        TaskListener listener = prDecisionContext.getListener();
        GHPullRequest remotePR = prDecisionContext.getRemotePR();
        if (remotePR.getState().equals((Object)GHIssueState.CLOSED)) {
            return null;
        }
        GitHubPRCause cause = null;
        Collection remoteLabels = remotePR.getRepository().getIssue(remotePR.getNumber()).getLabels();
        HashSet<String> existingLabels = new HashSet<String>();
        for (GHLabel ghLabel : remoteLabels) {
            existingLabels.add(ghLabel.getName());
        }
        if (existingLabels.containsAll(this.label.getLabelsSet())) {
            PrintStream logger = listener.getLogger();
            logger.println("Labels exist: " + String.valueOf(this.label.getLabelsSet()) + " found");
            cause = prDecisionContext.newCause(String.valueOf(this.label.getLabelsSet()) + " labels exist", this.isSkip());
        }
        return cause;
    }

    public GitHubPRLabel getLabel() {
        return this.label;
    }

    public boolean isSkip() {
        return this.skip;
    }

    @Symbol(value={"labelsExist"})
    @Extension
    public static class DescriptorImpl
    extends GitHubPREventDescriptor {
        @NonNull
        public String getDisplayName() {
            return GitHubPRLabelExistsEvent.DISPLAY_NAME;
        }
    }
}

