/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest.events.impl;

import com.github.kostyasha.github.integration.generic.GitHubPRDecisionContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRCause;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRLabel;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRPullRequest;
import org.jenkinsci.plugins.github.pullrequest.events.GitHubPREvent;
import org.jenkinsci.plugins.github.pullrequest.events.GitHubPREventDescriptor;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHLabel;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubPRLabelAddedEvent
extends GitHubPREvent {
    private static final String DISPLAY_NAME = "Labels added";
    private static final Logger LOG = LoggerFactory.getLogger(GitHubPRLabelAddedEvent.class);
    private final GitHubPRLabel label;

    @DataBoundConstructor
    public GitHubPRLabelAddedEvent(GitHubPRLabel label) {
        this.label = label;
    }

    public GitHubPRLabel getLabel() {
        return this.label;
    }

    @Override
    public GitHubPRCause check(@NonNull GitHubPRDecisionContext prDecisionContext) throws IOException {
        TaskListener listener = prDecisionContext.getListener();
        GitHubPRPullRequest localPR = prDecisionContext.getLocalPR();
        GHPullRequest remotePR = prDecisionContext.getRemotePR();
        if (remotePR.getState().equals((Object)GHIssueState.CLOSED)) {
            return null;
        }
        if (Objects.isNull(this.label)) {
            LOG.error("Label is null. Bad configured event: {}", (Object)this.getDescriptor().getDisplayName());
            throw new IllegalStateException("Label is null. Bad configured event: " + this.getDescriptor().getDisplayName());
        }
        if (localPR != null && localPR.getLabels().containsAll(this.label.getLabelsSet())) {
            return null;
        }
        GitHubPRCause cause = null;
        Collection labels = remotePR.getRepository().getIssue(remotePR.getNumber()).getLabels();
        HashSet<String> existingLabels = new HashSet<String>();
        for (GHLabel curLabel : labels) {
            existingLabels.add(curLabel.getName());
        }
        if (existingLabels.containsAll(this.label.getLabelsSet())) {
            PrintStream logger = listener.getLogger();
            logger.println("Labels added: state has changed (" + String.valueOf(this.label.getLabelsSet()) + " labels were added");
            cause = prDecisionContext.newCause(String.valueOf(this.label.getLabelsSet()) + " labels were added", false);
        }
        return cause;
    }

    @Symbol(value={"labelsAdded"})
    @Extension
    public static class DescriptorImpl
    extends GitHubPREventDescriptor {
        @NonNull
        public String getDisplayName() {
            return GitHubPRLabelAddedEvent.DISPLAY_NAME;
        }
    }
}

