/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest.events.impl;

import com.github.kostyasha.github.integration.generic.GitHubPRDecisionContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRCause;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRPullRequest;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRTrigger;
import org.jenkinsci.plugins.github.pullrequest.events.GitHubPREvent;
import org.jenkinsci.plugins.github.pullrequest.events.GitHubPREventDescriptor;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubPRDescriptionEvent
extends GitHubPREvent {
    private static final String DISPLAY_NAME = "Description matched to pattern";
    private static final Logger LOG = LoggerFactory.getLogger(GitHubPRDescriptionEvent.class);
    private final String skipMsg;

    @DataBoundConstructor
    public GitHubPRDescriptionEvent(String skipMsg) {
        this.skipMsg = skipMsg;
    }

    @Override
    public GitHubPRCause check(@NonNull GitHubPRDecisionContext prDecisionContext) throws IOException {
        TaskListener listener = prDecisionContext.getListener();
        GitHubPRPullRequest localPR = prDecisionContext.getLocalPR();
        GHPullRequest remotePR = prDecisionContext.getRemotePR();
        String fullName = this.getFullName(prDecisionContext);
        PrintStream logger = listener.getLogger();
        GitHubPRCause cause = null;
        String pullRequestBody = remotePR.getBody() != null ? remotePR.getBody().trim() : "";
        LOG.debug("Job: '{}', trigger event: '{}', body for test: '{}'", new Object[]{fullName, DISPLAY_NAME, StringEscapeUtils.escapeJava((String)pullRequestBody)});
        if (StringUtils.isNotBlank((String)pullRequestBody)) {
            HashSet<String> skipBuildPhrases = new HashSet<String>(Arrays.asList(this.getSkipMsg().split("[\\r\\n]+")));
            skipBuildPhrases.remove("");
            LOG.debug("Job: '{}', trigger event: '{}', skipBuildPhrases: '{}'", new Object[]{fullName, DISPLAY_NAME, skipBuildPhrases});
            for (String skipBuildPhrase : skipBuildPhrases) {
                Pattern skipBuildPhrasePattern = Pattern.compile(skipBuildPhrase = skipBuildPhrase.trim());
                if (skipBuildPhrasePattern.matcher(pullRequestBody).matches()) {
                    LOG.info("Job: '{}', trigger event: '{}', PR body '{}' matches skipBuildPhrase '{}'.", new Object[]{fullName, DISPLAY_NAME, StringEscapeUtils.escapeJava((String)pullRequestBody), skipBuildPhrase});
                    logger.println("Description matched to pattern: Pull request description contains " + skipBuildPhrase + ", skipping");
                    cause = prDecisionContext.newCause("Pull request description contains " + skipBuildPhrase + ", skipping", true);
                    break;
                }
                LOG.trace("Job: '{}', trigger event: '{}', phrase: '{}' didn't match to '{}'", new Object[]{fullName, DISPLAY_NAME, skipBuildPhrase, StringEscapeUtils.escapeJava((String)pullRequestBody)});
            }
        }
        return cause;
    }

    private String getFullName(GitHubPRDecisionContext context) {
        GitHubPRTrigger prTrigger = context.getTrigger();
        if (Objects.nonNull((Object)prTrigger)) {
            return prTrigger.getJob().getFullName();
        }
        return context.getScmSource().getOwner().getFullName();
    }

    public String getSkipMsg() {
        return this.skipMsg;
    }

    @Symbol(value={"description"})
    @Extension
    public static class DescriptorImpl
    extends GitHubPREventDescriptor {
        @NonNull
        public String getDisplayName() {
            return GitHubPRDescriptionEvent.DISPLAY_NAME;
        }
    }
}

