/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest.events.impl;

import com.github.kostyasha.github.integration.generic.GitHubPRDecisionContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Objects;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRCause;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRPullRequest;
import org.jenkinsci.plugins.github.pullrequest.events.GitHubPREvent;
import org.jenkinsci.plugins.github.pullrequest.events.GitHubPREventDescriptor;
import org.jenkinsci.plugins.github.pullrequest.events.impl.GitHubPROpenEvent;
import org.kohsuke.github.GHCommitPointer;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubPRCommitEvent
extends GitHubPREvent {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHubPROpenEvent.class);
    private static final String DISPLAY_NAME = "Commit changed";

    @DataBoundConstructor
    public GitHubPRCommitEvent() {
    }

    @Override
    public GitHubPRCause check(@NonNull GitHubPRDecisionContext prDecisionContext) throws IOException {
        TaskListener listener = prDecisionContext.getListener();
        GHPullRequest remotePR = prDecisionContext.getRemotePR();
        GitHubPRPullRequest localPR = prDecisionContext.getLocalPR();
        if (remotePR.getState().equals((Object)GHIssueState.CLOSED)) {
            return null;
        }
        if (Objects.isNull(localPR)) {
            return null;
        }
        GitHubPRCause cause = null;
        GHCommitPointer head = remotePR.getHead();
        if (!localPR.getHeadSha().equals(head.getSha())) {
            LOGGER.debug("New commit. Sha: {} => {}", (Object)localPR.getHeadSha(), (Object)head.getSha());
            PrintStream logger = listener.getLogger();
            logger.println(((Object)((Object)this)).getClass().getSimpleName() + ": new commit found, sha " + head.getSha());
            cause = prDecisionContext.newCause(DISPLAY_NAME, false);
        }
        return cause;
    }

    @Symbol(value={"commitChanged"})
    @Extension
    public static class DescriptorImpl
    extends GitHubPREventDescriptor {
        @NonNull
        public final String getDisplayName() {
            return GitHubPRCommitEvent.DISPLAY_NAME;
        }
    }
}

