/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest.events.impl;

import com.github.kostyasha.github.integration.generic.GitHubPRDecisionContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRCause;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRPullRequest;
import org.jenkinsci.plugins.github.pullrequest.events.GitHubPREvent;
import org.jenkinsci.plugins.github.pullrequest.events.GitHubPREventDescriptor;
import org.jenkinsci.plugins.github.pullrequest.restrictions.GitHubPRUserRestriction;
import org.kohsuke.github.GHIssueComment;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubPRCommentEvent
extends GitHubPREvent {
    private static final String DISPLAY_NAME = "Comment matched to pattern";
    private static final Logger LOG = LoggerFactory.getLogger(GitHubPRCommentEvent.class);
    private String comment = "";

    public String getComment() {
        return this.comment;
    }

    @DataBoundConstructor
    public GitHubPRCommentEvent(String comment) {
        this.comment = comment;
    }

    @Override
    public GitHubPRCause check(@NonNull GitHubPRDecisionContext prDecisionContext) {
        TaskListener listener = prDecisionContext.getListener();
        PrintStream llog = listener.getLogger();
        GitHubPRPullRequest localPR = prDecisionContext.getLocalPR();
        GHPullRequest remotePR = prDecisionContext.getRemotePR();
        GitHubPRUserRestriction prUserRestriction = prDecisionContext.getPrUserRestriction();
        GitHubPRCause cause = null;
        try {
            for (GHIssueComment issueComment : remotePR.getComments()) {
                if (!Objects.isNull(localPR) && !Objects.isNull(localPR.getLastCommentCreatedAt()) && localPR.getLastCommentCreatedAt().compareTo(issueComment.getCreatedAt()) >= 0) continue;
                llog.printf("%s: state has changed (new comment found - '%s')%n", DISPLAY_NAME, issueComment.getBody());
                cause = this.checkComment(prDecisionContext, issueComment, prUserRestriction, listener);
                if (!Objects.nonNull((Object)cause)) continue;
                break;
            }
        }
        catch (Exception e) {
            LOG.warn("Couldn't obtain comments: {}", (Throwable)e);
            listener.error("Couldn't obtain comments", new Object[]{e});
        }
        if (Objects.isNull(cause)) {
            LOG.debug("No matching comments found for {}", (Object)remotePR.getNumber());
            llog.println("No matching comments found for " + remotePR.getNumber());
        }
        return cause;
    }

    private GitHubPRCause checkComment(GitHubPRDecisionContext prDecisionContext, GHIssueComment issueComment, GitHubPRUserRestriction userRestriction, TaskListener listener) {
        GitHubPRCause cause = null;
        try {
            Matcher matcher;
            String body = issueComment.getBody();
            if ((Objects.isNull(userRestriction) || userRestriction.isWhitelisted(issueComment.getUser())) && (matcher = Pattern.compile(this.comment).matcher(body)).matches()) {
                listener.getLogger().println("Comment matched to pattern: matching comment " + body);
                LOG.trace("Event matches comment '{}'", (Object)body);
                cause = prDecisionContext.newCause("Comment matches to criteria.", false);
                cause.withCommentBody(body);
                cause.withCommentAuthorName(issueComment.getUser().getName());
                cause.withCommentAuthorEmail(issueComment.getUser().getEmail());
                if (matcher.groupCount() > 0) {
                    cause.withCommentBodyMatch(matcher.group(1));
                }
            }
        }
        catch (IOException ex) {
            LOG.error("Couldn't check comment #{}, skipping it.", (Object)issueComment.getId(), (Object)ex);
        }
        return cause;
    }

    @Symbol(value={"commentPattern"})
    @Extension
    public static class DescriptorImpl
    extends GitHubPREventDescriptor {
        @NonNull
        public String getDisplayName() {
            return GitHubPRCommentEvent.DISPLAY_NAME;
        }
    }
}

