/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest.events.impl;

import com.github.kostyasha.github.integration.generic.GitHubPRDecisionContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Objects;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRCause;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRPullRequest;
import org.jenkinsci.plugins.github.pullrequest.events.GitHubPREvent;
import org.jenkinsci.plugins.github.pullrequest.events.GitHubPREventDescriptor;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubPRCloseEvent
extends GitHubPREvent {
    private static final String DISPLAY_NAME = "Pull Request Closed";
    private static final Logger LOG = LoggerFactory.getLogger(GitHubPRCloseEvent.class);

    @DataBoundConstructor
    public GitHubPRCloseEvent() {
    }

    @Override
    public GitHubPRCause check(@NonNull GitHubPRDecisionContext prDecisionContext) throws IOException {
        TaskListener listener = prDecisionContext.getListener();
        GHPullRequest remotePR = prDecisionContext.getRemotePR();
        PrintStream logger = listener.getLogger();
        GitHubPRPullRequest localPR = prDecisionContext.getLocalPR();
        if (Objects.isNull(localPR)) {
            return null;
        }
        GitHubPRCause cause = null;
        if (remotePR.getState().equals((Object)GHIssueState.CLOSED)) {
            logger.println("Pull Request Closed: state has changed (PR was closed)");
            cause = prDecisionContext.newCause("PR was closed", false);
        }
        return cause;
    }

    @Symbol(value={"close"})
    @Extension
    public static class DescriptorImpl
    extends GitHubPREventDescriptor {
        @NonNull
        public String getDisplayName() {
            return GitHubPRCloseEvent.DISPLAY_NAME;
        }
    }
}

