/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest.data;

import com.github.kostyasha.github.integration.generic.GitHubCause;
import com.github.kostyasha.github.integration.generic.GitHubEnv;
import com.github.kostyasha.github.integration.generic.GitHubRepoEnv;
import hudson.model.ParameterValue;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRCause;

public enum GitHubPREnv implements GitHubEnv<GitHubPRCause>
{
    TRIGGER_SENDER_AUTHOR(GitHubPRCause::getTriggerSenderName),
    TRIGGER_SENDER_EMAIL(GitHubPRCause::getTriggerSenderEmail),
    COMMIT_AUTHOR_NAME(GitHubPRCause::getCommitAuthorName),
    COMMIT_AUTHOR_EMAIL(GitHubPRCause::getCommitAuthorEmail),
    TARGET_BRANCH(GitHubPRCause::getTargetBranch),
    SOURCE_BRANCH(GitHubPRCause::getSourceBranch),
    AUTHOR_EMAIL(GitHubPRCause::getPrAuthorEmail),
    BODY(GitHubPRCause::getBody),
    SHORT_DESC(GitHubPRCause::getShortDescription),
    TITLE(GitHubCause::getTitle),
    URL(c -> c.getHtmlUrl().toString()),
    SOURCE_REPO_OWNER(GitHubPRCause::getSourceRepoOwner),
    HEAD_SHA(GitHubPRCause::getHeadSha),
    COND_REF(GitHubPRCause::getCondRef),
    CAUSE_SKIP(GitHubCause::isSkip),
    NUMBER(c -> String.valueOf(c.getNumber())),
    STATE(GitHubPRCause::getState),
    COMMENT_AUTHOR_NAME(GitHubPRCause::getCommentAuthorName),
    COMMENT_AUTHOR_EMAIL(GitHubPRCause::getCommentAuthorEmail),
    COMMENT_BODY(GitHubPRCause::getCommentBody),
    COMMENT_BODY_MATCH(GitHubPRCause::getCommentBodyMatch),
    LABELS(c -> String.join((CharSequence)",", c.getLabels()));

    public static final String PREFIX = "GITHUB_PR_";
    private Function<GitHubPRCause, ParameterValue> fun;

    private GitHubPREnv(Function<GitHubPRCause, String> fun) {
        this.fun = c -> this.param((String)fun.apply((GitHubPRCause)((Object)c)));
    }

    private GitHubPREnv(Predicate<GitHubPRCause> fun) {
        this.fun = c -> this.param(fun.test((GitHubPRCause)((Object)c)));
    }

    @Override
    public void addParam(GitHubPRCause cause, List<ParameterValue> params) {
        params.add(this.fun.apply(cause));
    }

    public String toString() {
        return PREFIX.concat(this.name());
    }

    public static void getParams(GitHubPRCause cause, List<ParameterValue> params) {
        GitHubEnv.getParams(GitHubPREnv.class, cause, params);
        GitHubEnv.getParams(GitHubRepoEnv.class, cause, params);
    }
}

