/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest.builders;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.Objects;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRCause;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRMessage;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRTrigger;
import org.jenkinsci.plugins.github.pullrequest.utils.JobHelper;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.github.GHCommitState;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubPRStatusBuilder
extends Builder
implements SimpleBuildStep {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHubPRStatusBuilder.class);
    public static final GitHubPRMessage DEFAULT_MESSAGE = new GitHubPRMessage("${GITHUB_PR_COND_REF} run started");
    @CheckForNull
    private GitHubPRMessage statusMessage = DEFAULT_MESSAGE;

    @Restricted(value={NoExternalUse.class})
    public GitHubPRStatusBuilder() {
    }

    @DataBoundConstructor
    public GitHubPRStatusBuilder(GitHubPRMessage statusMessage) {
        if (statusMessage != null && StringUtils.isNotBlank((CharSequence)statusMessage.getContent())) {
            this.statusMessage = statusMessage;
        }
    }

    public GitHubPRMessage getStatusMessage() {
        return this.statusMessage;
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        GitHubPRTrigger trigger = JobHelper.ghPRTriggerFromRun(run);
        if (Objects.isNull((Object)trigger)) {
            return;
        }
        GitHubPRCause cause = JobHelper.ghPRCauseFromRun(run);
        if (Objects.isNull((Object)cause)) {
            return;
        }
        try {
            if (Objects.nonNull((Object)this.statusMessage)) {
                String url = trigger.getDescriptor().getJenkinsURL() + run.getUrl();
                trigger.getRemoteRepository().createCommitStatus(cause.getHeadSha(), GHCommitState.PENDING, url, this.statusMessage.expandAll(run, listener), run.getParent().getFullName());
            }
        }
        catch (Exception e) {
            listener.getLogger().println("Can't update build description");
            LOGGER.error("Can't set commit status", (Throwable)e);
        }
    }

    @Symbol(value={"gitHubPRStatus"})
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "GitHub PR: set 'pending' status";
        }
    }
}

