/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest;

import antlr.ANTLRException;
import com.github.kostyasha.github.integration.generic.GitHubTrigger;
import com.github.kostyasha.github.integration.generic.GitHubTriggerDescriptor;
import com.github.kostyasha.github.integration.generic.errors.impl.GitHubHookRegistrationError;
import com.github.kostyasha.github.integration.generic.utils.RetryableGitHubOperation;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.Util;
import hudson.model.Job;
import hudson.model.TaskListener;
import hudson.triggers.Trigger;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRCause;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRPollingLogAction;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRRepository;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRTriggerMode;
import org.jenkinsci.plugins.github.pullrequest.events.GitHubPREvent;
import org.jenkinsci.plugins.github.pullrequest.events.GitHubPREventDescriptor;
import org.jenkinsci.plugins.github.pullrequest.restrictions.GitHubPRBranchRestriction;
import org.jenkinsci.plugins.github.pullrequest.restrictions.GitHubPRUserRestriction;
import org.jenkinsci.plugins.github.pullrequest.trigger.JobRunnerForCause;
import org.jenkinsci.plugins.github.pullrequest.trigger.check.BranchRestrictionFilter;
import org.jenkinsci.plugins.github.pullrequest.trigger.check.LocalRepoUpdater;
import org.jenkinsci.plugins.github.pullrequest.trigger.check.NotUpdatedPRFilter;
import org.jenkinsci.plugins.github.pullrequest.trigger.check.PullRequestToCauseConverter;
import org.jenkinsci.plugins.github.pullrequest.trigger.check.SkipFirstRunForPRFilter;
import org.jenkinsci.plugins.github.pullrequest.trigger.check.SkipPRInBadState;
import org.jenkinsci.plugins.github.pullrequest.trigger.check.UserRestrictionFilter;
import org.jenkinsci.plugins.github.pullrequest.utils.LoggingTaskListenerWrapper;
import org.jenkinsci.plugins.github.pullrequest.utils.PRHelperFunctions;
import org.jenkinsci.plugins.github.pullrequest.webhook.WebhookInfoPredicates;
import org.jenkinsci.plugins.github.util.FluentIterableWrapper;
import org.jenkinsci.plugins.github.util.JobInfoHelpers;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRateLimit;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubPRTrigger
extends GitHubTrigger<GitHubPRTrigger> {
    private static final Logger LOG = LoggerFactory.getLogger(GitHubPRTrigger.class);
    public static final String FINISH_MSG = "Finished GitHub Pull Request trigger check";
    @CheckForNull
    private List<GitHubPREvent> events = new ArrayList<GitHubPREvent>();
    private boolean preStatus = false;
    @CheckForNull
    private GitHubPRUserRestriction userRestriction;
    @CheckForNull
    private GitHubPRBranchRestriction branchRestriction;
    @CheckForNull
    private transient GitHubPRPollingLogAction pollingLogAction;

    @Restricted(value={NoExternalUse.class})
    public GitHubPRTrigger() throws ANTLRException {
        super("");
    }

    @DataBoundConstructor
    public GitHubPRTrigger(String spec, GitHubPRTriggerMode triggerMode, List<GitHubPREvent> events) throws ANTLRException {
        super(spec);
        this.setTriggerMode(triggerMode);
        this.events = Util.fixNull(events);
    }

    @DataBoundSetter
    public void setPreStatus(boolean preStatus) {
        this.preStatus = preStatus;
    }

    @DataBoundSetter
    public void setUserRestriction(GitHubPRUserRestriction userRestriction) {
        this.userRestriction = userRestriction;
    }

    @DataBoundSetter
    public void setBranchRestriction(GitHubPRBranchRestriction branchRestriction) {
        this.branchRestriction = branchRestriction;
    }

    public boolean isPreStatus() {
        return this.preStatus;
    }

    @NonNull
    public List<GitHubPREvent> getEvents() {
        return Objects.nonNull(this.events) ? this.events : Collections.emptyList();
    }

    public GitHubPRUserRestriction getUserRestriction() {
        return this.userRestriction;
    }

    public GitHubPRBranchRestriction getBranchRestriction() {
        return this.branchRestriction;
    }

    @Override
    public void start(Job<?, ?> job, boolean newInstance) {
        LOG.info("Starting GitHub Pull Request trigger for project {}", (Object)job.getFullName());
        super.start(job, newInstance);
        if (newInstance && this.getRepoProvider().isManageHooks(this) && WebhookInfoPredicates.withHookTriggerMode().apply(job)) {
            try {
                this.getRepoProvider().registerHookFor(this);
                this.getErrorsAction().removeErrors(GitHubHookRegistrationError.class);
            }
            catch (Throwable error) {
                this.getErrorsAction().addOrReplaceError(new GitHubHookRegistrationError(String.format("Failed register hook for %s. <br/> Because %s", job.getFullName(), error.toString())));
                throw error;
            }
        }
    }

    @Override
    public void doRun() {
        this.doRun(null);
    }

    public void run() {
        if (this.getTriggerMode() != GitHubPRTriggerMode.LIGHT_HOOKS) {
            this.queueRun(null);
        }
    }

    @Override
    @CheckForNull
    public GitHubPRPollingLogAction getPollingLogAction() {
        if (Objects.isNull(this.pollingLogAction) && Objects.nonNull(this.job)) {
            this.pollingLogAction = new GitHubPRPollingLogAction((Job)this.job);
        }
        return this.pollingLogAction;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.getInstance().getDescriptor(((Object)((Object)this)).getClass());
    }

    @Deprecated
    public void queueRun(Job<?, ?> job, int prNumber) {
        this.job = job;
        this.queueRun(prNumber);
    }

    public void queueRun(Integer prNumber) {
        this.getDescriptor().getQueue().execute(() -> this.doRun(prNumber));
    }

    public synchronized void doRun(Integer prNumber) {
        if (Predicates.not((Predicate)JobInfoHelpers.isBuildable()).apply((Object)this.job)) {
            LOG.debug("Job {} is disabled, but trigger run!", (Object)(Objects.isNull(this.job) ? "<no job>" : ((Job)this.job).getFullName()));
            return;
        }
        if (!GitHubPRTrigger.isSupportedTriggerMode(this.getTriggerMode())) {
            LOG.warn("Trigger mode {} is not supported yet ({})", (Object)this.getTriggerMode(), (Object)((Job)this.job).getFullName());
            return;
        }
        GitHubPRRepository localRepository = (GitHubPRRepository)((Job)this.job).getAction(GitHubPRRepository.class);
        if (Objects.isNull(localRepository)) {
            LOG.warn("Can't get repository info, maybe project {} misconfigured?", (Object)((Job)this.job).getFullName());
            return;
        }
        try (LoggingTaskListenerWrapper listener = new LoggingTaskListenerWrapper(this.getPollingLogAction().getPollingLogFile(), Charsets.UTF_8);){
            long startTime = System.currentTimeMillis();
            listener.debug("Running GitHub Pull Request trigger check for {} on {}", DateFormat.getDateTimeInstance().format(new Date(startTime)), localRepository.getFullName());
            try {
                localRepository.actualise(this.getRemoteRepository(), (TaskListener)listener);
                List<GitHubPRCause> causes = this.readyToBuildCauses(localRepository, listener, prNumber);
                localRepository.saveQuietly();
                FluentIterableWrapper.from(causes).filter((Predicate)new JobRunnerForCause((Job)this.job, this)).toSet();
            }
            catch (Throwable t) {
                listener.error("Can't end trigger check!", t);
            }
            long duration = System.currentTimeMillis() - startTime;
            listener.info("Finished GitHub Pull Request trigger check for {} at {}. Duration: {}ms", localRepository.getFullName(), DateFormat.getDateTimeInstance().format(new Date()), duration);
        }
        catch (Exception e) {
            LOG.error("Can't process check ({})", (Object)e.getMessage(), (Object)e);
        }
    }

    private List<GitHubPRCause> readyToBuildCauses(@NonNull GitHubPRRepository localRepository, @NonNull LoggingTaskListenerWrapper listener, @Nullable Integer prNumber) {
        try {
            GitHub github = this.getRepoProvider().getGitHub(this);
            if (Objects.isNull(github)) {
                LOG.error("GitHub connection is null, check Repo Providers!");
                throw new IllegalStateException("GitHub connection is null, check Repo Providers!");
            }
            GHRateLimit rateLimitBefore = github.getRateLimit();
            listener.debug("GitHub rate limit before check: {}", rateLimitBefore);
            GHRepository remoteRepo = this.getRemoteRepository();
            Set<GHPullRequest> remotePulls = GitHubPRTrigger.pullRequestsToCheck(prNumber, remoteRepo, localRepository);
            ImmutableSet prepared = FluentIterableWrapper.from(remotePulls).filter((Predicate)SkipPRInBadState.badState(localRepository, (TaskListener)listener)).filter((Predicate)NotUpdatedPRFilter.notUpdated(localRepository, (TaskListener)listener)).toSet();
            List causes = FluentIterableWrapper.from((Iterable)prepared).filter(Predicates.and((Predicate[])new Predicate[]{SkipFirstRunForPRFilter.ifSkippedFirstRun((TaskListener)listener, this.isSkipFirstRun()), BranchRestrictionFilter.withBranchRestriction(listener, this.getBranchRestriction()), UserRestrictionFilter.withUserRestriction(listener, this.getUserRestriction())})).transform((Function)PullRequestToCauseConverter.toGitHubPRCause(localRepository, (TaskListener)listener, this)).filter(Predicates.notNull()).toList();
            LOG.trace("Causes count for {}: {}", (Object)localRepository.getFullName(), (Object)causes.size());
            FluentIterableWrapper.from(remotePulls).transform((Function)LocalRepoUpdater.updateLocalRepo(localRepository)).toSet();
            this.saveIfSkipFirstRun();
            GHRateLimit rateLimitAfter = github.getRateLimit();
            int consumed = rateLimitBefore.remaining - rateLimitAfter.remaining;
            LOG.info("GitHub rate limit after check {}: {}, consumed: {}, checked PRs: {}", new Object[]{localRepository.getFullName(), rateLimitAfter, consumed, remotePulls.size()});
            return causes;
        }
        catch (IOException e) {
            listener.error("Can't get build causes: ", e);
            return Collections.emptyList();
        }
    }

    private static boolean isSupportedTriggerMode(GitHubPRTriggerMode mode) {
        return mode != GitHubPRTriggerMode.LIGHT_HOOKS;
    }

    private static Set<GHPullRequest> pullRequestsToCheck(@Nullable Integer prNumber, @NonNull GHRepository remoteRepo, @NonNull GitHubPRRepository localRepo) throws IOException {
        if (prNumber != null) {
            return RetryableGitHubOperation.execute(() -> Collections.singleton(remoteRepo.getPullRequest(prNumber.intValue())));
        }
        List remotePulls = RetryableGitHubOperation.execute(() -> remoteRepo.getPullRequests(GHIssueState.OPEN));
        ImmutableSet remotePRNums = FluentIterableWrapper.from((Iterable)remotePulls).transform(PRHelperFunctions.extractPRNumber()).toSet();
        return FluentIterableWrapper.from(localRepo.getPulls().keySet()).filter(Predicates.not((Predicate)Predicates.in((Collection)remotePRNums))).transform(PRHelperFunctions.fetchRemotePR(remoteRepo)).filter(Predicates.notNull()).append((Iterable)remotePulls).toSet();
    }

    @Override
    public String getFinishMsg() {
        return FINISH_MSG;
    }

    @Symbol(value={"githubPullRequests"})
    @Extension
    public static class DescriptorImpl
    extends GitHubTriggerDescriptor {
        public DescriptorImpl() {
            this.load();
        }

        @NonNull
        public String getDisplayName() {
            return "GitHub Pull Requests";
        }

        public static List<GitHubPREventDescriptor> getEventDescriptors() {
            return GitHubPREventDescriptor.all();
        }

        public static DescriptorImpl get() {
            return (DescriptorImpl)((Object)Trigger.all().get(DescriptorImpl.class));
        }
    }
}

