/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest;

import com.cloudbees.jenkins.GitHubRepositoryName;
import com.coravy.hudson.plugins.github.GithubProjectProperty;
import com.github.kostyasha.github.integration.generic.GitHubRepositoryFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.XmlFile;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.TaskListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRRepository;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRTrigger;
import org.jenkinsci.plugins.github.pullrequest.utils.JobHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class GitHubPRRepositoryFactory
extends GitHubRepositoryFactory<GitHubPRRepositoryFactory, GitHubPRTrigger> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHubPRRepositoryFactory.class);

    @NonNull
    public Collection<? extends Action> createFor(@NonNull Job job) {
        try {
            if (Objects.nonNull((Object)JobHelper.ghPRTriggerFromJob(job))) {
                return Collections.singleton(GitHubPRRepositoryFactory.forProject(job));
            }
        }
        catch (Exception ex) {
            LOGGER.error("Bad configured project {} - {}", new Object[]{job.getFullName(), ex.getMessage(), ex});
        }
        return Collections.emptyList();
    }

    @NonNull
    private static GitHubPRRepository forProject(Job<?, ?> job) throws IOException {
        GitHubPRRepository localRepository;
        XmlFile configFile = new XmlFile(new File(job.getRootDir(), GitHubPRRepository.FILE));
        GitHubPRTrigger trigger = JobHelper.ghPRTriggerFromJob(job);
        Objects.requireNonNull(trigger, "Can't extract PR trigger from " + job.getFullName());
        GitHubRepositoryName repoFullName = trigger.getRepoFullName(job);
        GithubProjectProperty property = (GithubProjectProperty)job.getProperty(GithubProjectProperty.class);
        String githubUrl = property.getProjectUrl().toString();
        boolean save = false;
        if (configFile.exists()) {
            try {
                localRepository = (GitHubPRRepository)configFile.read();
            }
            catch (IOException e) {
                LOGGER.info("Can't read saved repository, re-creating new one", (Throwable)e);
                localRepository = new GitHubPRRepository(repoFullName.toString(), new URL(githubUrl));
                save = true;
            }
        } else {
            localRepository = new GitHubPRRepository(repoFullName.toString(), new URL(githubUrl));
            save = true;
        }
        localRepository.setJob(job);
        localRepository.setConfigFile(configFile);
        GitHubPRTrigger.DescriptorImpl prTriggerDescriptor = GitHubPRTrigger.DescriptorImpl.get();
        if (prTriggerDescriptor.isActualiseOnFactory()) {
            try {
                localRepository.actualise(trigger.getRemoteRepository(), TaskListener.NULL);
                save = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (save) {
            localRepository.save();
        }
        return localRepository;
    }

    @Override
    public Class<Job> type() {
        return Job.class;
    }
}

