/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest;

import com.github.kostyasha.github.integration.generic.GitHubRepository;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.XmlFile;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.queue.QueueTaskFuture;
import hudson.util.FormValidation;
import hudson.util.RunList;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRCause;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRPullRequest;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRTrigger;
import org.jenkinsci.plugins.github.pullrequest.trigger.JobRunnerForCause;
import org.jenkinsci.plugins.github.pullrequest.utils.JobHelper;
import org.kohsuke.github.GHRepository;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubPRRepository
extends GitHubRepository<GitHubPRRepository> {
    public static final String FILE = GitHubPRRepository.class.getName() + ".runtime.xml";
    private static final Logger LOG = LoggerFactory.getLogger(GitHubPRRepository.class);
    private Map<Integer, GitHubPRPullRequest> pulls = new ConcurrentHashMap<Integer, GitHubPRPullRequest>();

    public GitHubPRRepository(@NonNull GHRepository ghRepository) throws IOException {
        super(ghRepository);
    }

    public GitHubPRRepository(String repoFullName, URL githubUrl) {
        super(repoFullName, githubUrl);
    }

    @NonNull
    public Map<Integer, GitHubPRPullRequest> getPulls() {
        if (Objects.isNull(this.pulls)) {
            this.pulls = new ConcurrentHashMap<Integer, GitHubPRPullRequest>();
        }
        return this.pulls;
    }

    @NonNull
    public Map<Integer, List<Run<?, ?>>> getAllPrBuilds() {
        HashMap map = new HashMap();
        RunList runs = this.job.getBuilds();
        LOG.debug("Got builds for job {}", (Object)this.job.getFullName());
        for (Run run : runs) {
            GitHubPRCause cause = JobHelper.ghPRCauseFromRun(run);
            if (cause == null) continue;
            int number = cause.getNumber();
            ArrayList<Run> buildsByNumber = (ArrayList<Run>)map.get(number);
            if (Objects.isNull(buildsByNumber)) {
                buildsByNumber = new ArrayList<Run>();
                map.put(number, buildsByNumber);
            }
            buildsByNumber.add(run);
        }
        return map;
    }

    public String getIconFileName() {
        return GitHubPRPullRequest.getIconFileName();
    }

    public String getDisplayName() {
        return "GitHub PR";
    }

    public String getUrlName() {
        return "github-pullrequest";
    }

    @Override
    public void actualiseOnChange(@NonNull GHRepository ghRepository, @NonNull TaskListener listener) {
        if (this.changed) {
            listener.getLogger().println("Local settings changed, removing PRs in repository!");
            this.getPulls().clear();
        }
    }

    @Override
    @RequirePOST
    public FormValidation doClearRepo() throws IOException {
        FormValidation result;
        try {
            if (this.job.hasPermission(Item.DELETE)) {
                this.pulls.clear();
                this.save();
                result = FormValidation.ok((String)"Pulls deleted");
            } else {
                result = FormValidation.error((String)"Forbidden");
            }
        }
        catch (Exception e) {
            LOG.error("Can't delete repository file '{}'", (Object)this.configFile.getFile().getAbsolutePath(), (Object)e);
            result = FormValidation.error((Throwable)e, (String)"Can't delete: %s", (Object[])new Object[]{e.getMessage()});
        }
        return result;
    }

    @Override
    @RequirePOST
    public FormValidation doRunTrigger() {
        FormValidation result;
        try {
            if (this.job.hasPermission(Item.BUILD)) {
                GitHubPRTrigger trigger = JobHelper.ghPRTriggerFromJob(this.job);
                if (trigger != null) {
                    trigger.run();
                    result = FormValidation.ok((String)"GitHub PR trigger run");
                    LOG.debug("GitHub PR trigger run for {}", (Object)this.job);
                } else {
                    LOG.error("GitHub PR trigger not available for {}", (Object)this.job);
                    result = FormValidation.error((String)"GitHub PR trigger not available");
                }
            } else {
                LOG.warn("No permissions to run GitHub PR trigger");
                result = FormValidation.error((String)"Forbidden");
            }
        }
        catch (Exception e) {
            LOG.error("Can't run trigger", (Throwable)e);
            result = FormValidation.error((Throwable)e, (String)"Can't run trigger: %s", (Object[])new Object[]{e.getMessage()});
        }
        return result;
    }

    @Override
    @RequirePOST
    public FormValidation doRebuildAllFailed() throws IOException {
        FormValidation result;
        try {
            if (this.job.hasPermission(Item.BUILD)) {
                Map<Integer, List<Run<?, ?>>> builds = this.getAllPrBuilds();
                for (List<Run<?, ?>> buildList : builds.values()) {
                    if (buildList.isEmpty() || !Result.FAILURE.equals(buildList.get(0).getResult())) continue;
                    Run<?, ?> lastBuild = buildList.get(0);
                    JobHelper.rebuild(lastBuild);
                }
                result = FormValidation.ok((String)"Rebuild scheduled");
            } else {
                result = FormValidation.error((String)"Forbidden");
            }
        }
        catch (Exception e) {
            LOG.error("Can't start rebuild", (Throwable)e);
            result = FormValidation.error((Throwable)e, (String)"Can't start rebuild: %s", (Object[])new Object[]{e.getMessage()});
        }
        return result;
    }

    @Override
    public FormValidation doBuild(StaplerRequest req) throws IOException {
        FormValidation result;
        try {
            if (!this.job.hasPermission(Item.BUILD)) {
                return FormValidation.error((String)"Forbidden");
            }
            String prNumberParam = "prNumber";
            int prId = 0;
            if (req.hasParameter("prNumber")) {
                prId = Integer.valueOf(req.getParameter("prNumber"));
            }
            if (prId == 0 || !this.getPulls().containsKey(prId)) {
                return FormValidation.error((String)"No branch to build");
            }
            GitHubPRPullRequest localPR = this.getPulls().get(prId);
            GitHubPRCause cause = new GitHubPRCause(localPR, null, this, false, "Manual run.");
            JobRunnerForCause runner = new JobRunnerForCause(this.getJob(), JobHelper.ghPRTriggerFromJob(this.getJob()));
            QueueTaskFuture<?> queueTaskFuture = runner.startJob(cause);
            result = Objects.nonNull(queueTaskFuture) ? FormValidation.ok((String)"Build scheduled") : FormValidation.warning((String)"Build not scheduled");
        }
        catch (Exception e) {
            LOG.error("Can't start build", (Object)e.getMessage());
            result = FormValidation.error((Throwable)e, (String)("Can't start build: " + e.getMessage()));
        }
        return result;
    }

    @Override
    @RequirePOST
    public FormValidation doRebuild(StaplerRequest req) throws IOException {
        FormValidation result;
        try {
            Map<Integer, List<Run<?, ?>>> builds;
            List<Run<?, ?>> prBuilds;
            if (!this.job.hasPermission(Item.BUILD)) {
                return FormValidation.error((String)"Forbidden");
            }
            String prNumberParam = "prNumber";
            int prId = 0;
            if (req.hasParameter("prNumber")) {
                prId = Integer.valueOf(req.getParameter("prNumber"));
            }
            result = (prBuilds = (builds = this.getAllPrBuilds()).get(prId)) != null && !prBuilds.isEmpty() ? (JobHelper.rebuild(prBuilds.get(0)) ? FormValidation.ok((String)"Rebuild scheduled") : FormValidation.warning((String)"Rebuild not scheduled")) : FormValidation.warning((String)"Build not found");
        }
        catch (Exception e) {
            LOG.error("Can't start rebuild", (Throwable)e);
            result = FormValidation.error((Throwable)e, (String)("Can't start rebuild: " + e.getMessage()));
        }
        return result;
    }

    @Override
    public void setJob(Job<?, ?> job) {
        this.job = job;
    }

    @Override
    public void setConfigFile(XmlFile configFile) {
        this.configFile = configFile;
    }
}

