/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest;

import com.github.kostyasha.github.integration.generic.utils.RetryableGitHubOperation;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Functions;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.kohsuke.github.GHCommitPointer;
import org.kohsuke.github.GHIssueComment;
import org.kohsuke.github.GHLabel;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubPRPullRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHubPRPullRequest.class);
    private final int number;
    private final Date issueUpdatedAt;
    private String title;
    private String body;
    private Date prUpdatedAt;
    private String headSha;
    private String headRef;
    private Boolean mergeable;
    private String baseRef;
    private String userEmail;
    private String userLogin;
    private URL htmlUrl;
    private Set<String> labels;
    @CheckForNull
    private Date lastCommentCreatedAt;
    private String sourceRepoOwner;
    private String state;
    private boolean inBadState = false;

    public GitHubPRPullRequest(GHPullRequest pr) {
        try {
            this.userLogin = pr.getUser().getLogin();
            this.number = pr.getNumber();
            this.prUpdatedAt = pr.getUpdatedAt();
            this.issueUpdatedAt = pr.getIssueUpdatedAt();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        GHCommitPointer prHead = pr.getHead();
        this.headSha = prHead.getSha();
        this.headRef = prHead.getRef();
        this.sourceRepoOwner = prHead.getRepository() == null ? null : prHead.getRepository().getOwnerName();
        this.title = pr.getTitle();
        this.baseRef = pr.getBase().getRef();
        this.htmlUrl = pr.getHtmlUrl();
        try {
            Date maxDate = new Date(0L);
            List comments = RetryableGitHubOperation.execute(() -> ((GHPullRequest)pr).getComments());
            for (GHIssueComment comment : comments) {
                if (comment.getCreatedAt().compareTo(maxDate) <= 0) continue;
                maxDate = comment.getCreatedAt();
            }
            this.lastCommentCreatedAt = maxDate.getTime() == 0L ? null : new Date(maxDate.getTime());
        }
        catch (IOException e) {
            LOGGER.error("Can't get comments for PR: {}", (Object)pr.getNumber(), (Object)e);
            this.lastCommentCreatedAt = null;
        }
        try {
            this.userEmail = RetryableGitHubOperation.execute(() -> pr.getUser().getEmail());
        }
        catch (Exception e) {
            LOGGER.error("Can't get GitHub user email.", (Throwable)e);
            this.userEmail = "";
        }
        GHRepository remoteRepo = pr.getRepository();
        try {
            this.updateLabels(RetryableGitHubOperation.execute(() -> remoteRepo.getIssue(this.number).getLabels()));
        }
        catch (IOException e) {
            LOGGER.error("Can't retrieve label list: {}", (Throwable)e);
            this.inBadState = true;
        }
        try {
            this.mergeable = RetryableGitHubOperation.execute(() -> ((GHPullRequest)pr).getMergeable());
        }
        catch (IOException e) {
            LOGGER.error("Can't get mergeable status.", (Throwable)e);
            this.mergeable = false;
        }
        this.state = pr.getState().toString();
        this.body = pr.getBody();
    }

    public int getNumber() {
        return this.number;
    }

    public String getHeadSha() {
        return this.headSha;
    }

    public boolean isMergeable() {
        return Objects.isNull(this.mergeable) ? false : this.mergeable;
    }

    public String getBaseRef() {
        return this.baseRef;
    }

    public String getHeadRef() {
        return this.headRef;
    }

    public String getUserEmail() {
        return this.userEmail;
    }

    public String getTitle() {
        return this.title;
    }

    public String getBody() {
        return this.body;
    }

    @NonNull
    public Set<String> getLabels() {
        return Objects.isNull(this.labels) ? Collections.emptySet() : this.labels;
    }

    @CheckForNull
    public Date getLastCommentCreatedAt() {
        return this.lastCommentCreatedAt;
    }

    public URL getHtmlUrl() {
        return this.htmlUrl;
    }

    public Date getPrUpdatedAt() {
        return new Date(this.prUpdatedAt.getTime());
    }

    public Date getIssueUpdatedAt() {
        return this.issueUpdatedAt;
    }

    public String getUserLogin() {
        return this.userLogin;
    }

    public String getSourceRepoOwner() {
        return this.sourceRepoOwner;
    }

    @CheckForNull
    public String getState() {
        return this.state;
    }

    public void setLabels(Set<String> labels) {
        this.labels = labels;
    }

    private void updateLabels(Collection<GHLabel> labels) {
        this.labels = new HashSet<String>();
        for (GHLabel label : labels) {
            this.labels.add(label.getName());
        }
    }

    public boolean isInBadState() {
        return this.inBadState || Objects.isNull(this.labels);
    }

    public static String getIconFileName() {
        return Functions.getResourcePath() + "/plugin/github-pullrequest/git-pull-request.svg";
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }
}

