/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubPRMessage
extends AbstractDescribableImpl<GitHubPRMessage> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHubPRMessage.class);
    private String content;

    @DataBoundConstructor
    public GitHubPRMessage(String content) {
        this.content = content;
    }

    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    public String expandAll(Run<?, ?> run, TaskListener listener) throws IOException, InterruptedException {
        return GitHubPRMessage.expandAll(this.getContent(), run, listener);
    }

    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    public static String expandAll(String content, Run<?, ?> run, TaskListener listener) throws IOException, InterruptedException {
        if (StringUtils.isEmpty((String)content)) {
            return content;
        }
        String body = run.getEnvironment(listener).expand(content);
        if (run instanceof AbstractBuild) {
            AbstractBuild build = (AbstractBuild)run;
            body = Util.replaceMacro((String)body, (VariableResolver)build.getBuildVariableResolver());
            try {
                Jenkins jenkins = Jenkins.getActiveInstance();
                ClassLoader uberClassLoader = jenkins.pluginManager.uberClassLoader;
                ArrayList macros = null;
                if (Objects.nonNull(jenkins.getPlugin("token-macro"))) {
                    if (Objects.nonNull(jenkins.getPlugin("email-ext"))) {
                        Class<?> contentBuilderClazz = uberClassLoader.loadClass("hudson.plugins.emailext.plugins.ContentBuilder");
                        Method getPrivateMacrosMethod = contentBuilderClazz.getDeclaredMethod("getPrivateMacros", new Class[0]);
                        macros = new ArrayList((Collection)getPrivateMacrosMethod.invoke(null, new Object[0]));
                    }
                    Class<?> tokenMacroClazz = uberClassLoader.loadClass("org.jenkinsci.plugins.tokenmacro.TokenMacro");
                    Method tokenMacroExpand = tokenMacroClazz.getDeclaredMethod("expand", AbstractBuild.class, TaskListener.class, String.class, Boolean.TYPE, List.class);
                    body = (String)tokenMacroExpand.invoke(null, build, listener, body, false, macros);
                }
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Can't find class", (Throwable)e);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.error("Can't evaluate macro", (Throwable)e);
            }
        }
        return body;
    }

    public String getContent() {
        return this.content;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Symbol(value={"githubPRMessage"})
    @Extension
    public static class DescriptorImpl
    extends Descriptor<GitHubPRMessage> {
        public String getDisplayName() {
            return "Expandable comment field";
        }
    }
}

