/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest;

import com.google.common.base.Joiner;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class GitHubPRLabel
implements Describable<GitHubPRLabel> {
    private Set<String> labels;

    @DataBoundConstructor
    public GitHubPRLabel(String labels) {
        this(new HashSet<String>(Arrays.asList(labels.split("\n"))));
    }

    public GitHubPRLabel(Set<String> labels) {
        this.labels = labels;
    }

    public String getLabels() {
        return Joiner.on((String)"\n").skipNulls().join(this.labels);
    }

    @NonNull
    public Set<String> getLabelsSet() {
        return Objects.nonNull(this.labels) ? this.labels : Collections.emptySet();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.getInstance().getDescriptor(GitHubPRLabel.class);
    }

    @Symbol(value={"labels"})
    @Extension
    public static class DescriptorImpl
    extends Descriptor<GitHubPRLabel> {
        @NonNull
        public String getDisplayName() {
            return "Labels";
        }
    }
}

