/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest;

import com.github.kostyasha.github.integration.generic.GitHubCause;
import com.github.kostyasha.github.integration.generic.GitHubRepository;
import com.github.kostyasha.github.integration.multibranch.head.GitHubPRSCMHead;
import com.github.kostyasha.github.integration.multibranch.head.GitHubSCMHead;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Action;
import hudson.model.ParameterValue;
import hudson.model.Run;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import jenkins.scm.api.SCMSourceOwner;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRPollingLogAction;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRPullRequest;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRRepository;
import org.jenkinsci.plugins.github.pullrequest.data.GitHubPREnv;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubPRCause
extends GitHubCause<GitHubPRCause> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHubPRCause.class);
    private String headSha;
    private int number;
    private boolean mergeable;
    private String targetBranch;
    private String sourceBranch;
    private String prAuthorEmail;
    private String body;
    private String sourceRepoOwner;
    private String triggerSenderName = "";
    private String triggerSenderEmail = "";
    private Set<String> labels;
    private String commitAuthorName;
    private String commitAuthorEmail;
    private String condRef;
    private String state;
    private String commentAuthorName;
    private String commentAuthorEmail;
    private String commentBody;
    private String commentBodyMatch;

    public GitHubPRCause() {
    }

    public GitHubPRCause(GHPullRequest remotePr, GitHubPRRepository localRepo, String reason, boolean skip) {
        this(new GitHubPRPullRequest(remotePr), GitHubPRCause.unwrapUser(remotePr), localRepo, skip, reason);
        this.withRemoteData(remotePr);
        if (localRepo != null) {
            this.withLocalRepo(localRepo);
        }
    }

    private static GHUser unwrapUser(GHPullRequest remotePr) {
        try {
            return remotePr.getUser();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Deprecated
    public GitHubPRCause(GHPullRequest remotePr, String reason, boolean skip) {
        this(remotePr, null, reason, skip);
    }

    public GitHubPRCause(GitHubPRPullRequest pr, GHUser triggerSender, GitHubPRRepository localRepo, boolean skip, String reason) {
        this(pr.getHeadSha(), pr.getNumber(), pr.isMergeable(), pr.getBaseRef(), pr.getHeadRef(), pr.getUserEmail(), pr.getTitle(), pr.getHtmlUrl(), pr.getSourceRepoOwner(), pr.getLabels(), triggerSender, skip, reason, "", "", pr.getState());
        this.body = pr.getBody();
        if (localRepo != null) {
            this.withLocalRepo(localRepo);
        }
    }

    @Deprecated
    public GitHubPRCause(GitHubPRPullRequest pr, GHUser triggerSender, boolean skip, String reason) {
        this(pr, triggerSender, null, skip, reason);
    }

    public GitHubPRCause(String headSha, int number, boolean mergeable, String targetBranch, String sourceBranch, String prAuthorEmail, String title, URL htmlUrl, String sourceRepoOwner, Set<String> labels, GHUser triggerSender, boolean skip, String reason, String commitAuthorName, String commitAuthorEmail, String state) {
        this.headSha = headSha;
        this.number = number;
        this.mergeable = mergeable;
        this.targetBranch = targetBranch;
        this.sourceBranch = sourceBranch;
        this.prAuthorEmail = prAuthorEmail;
        this.withTitle(title);
        this.withHtmlUrl(htmlUrl);
        this.sourceRepoOwner = sourceRepoOwner;
        this.labels = labels;
        this.withSkip(skip);
        this.withReason(reason);
        this.commitAuthorName = commitAuthorName;
        this.commitAuthorEmail = commitAuthorEmail;
        if (Objects.nonNull(triggerSender)) {
            try {
                this.triggerSenderName = triggerSender.getName();
            }
            catch (IOException e) {
                LOGGER.error("Can't get trigger sender name from remote PR");
            }
            try {
                this.triggerSenderEmail = triggerSender.getEmail();
            }
            catch (IOException e) {
                LOGGER.error("Can't get trigger sender email from remote PR");
            }
        }
        this.condRef = mergeable ? "merge" : "head";
        this.state = state;
    }

    @Override
    public GitHubPRCause withLocalRepo(@NonNull GitHubRepository localRepo) {
        this.withGitUrl(localRepo.getGitUrl());
        this.withSshUrl(localRepo.getSshUrl());
        return this;
    }

    public GitHubPRCause(GitHubPRCause orig) {
        this(orig.getHeadSha(), orig.getNumber(), orig.isMergeable(), orig.getTargetBranch(), orig.getSourceBranch(), orig.getPRAuthorEmail(), orig.getTitle(), orig.getHtmlUrl(), orig.getSourceRepoOwner(), orig.getLabels(), null, orig.isSkip(), orig.getReason(), orig.getCommitAuthorName(), orig.getCommitAuthorEmail(), orig.getState());
        this.withTriggerSenderName(orig.getTriggerSenderEmail());
        this.withTriggerSenderEmail(orig.getTriggerSenderEmail());
        this.withBody(orig.getBody());
        this.withCommentAuthorName(orig.getCommentAuthorName());
        this.withCommentAuthorEmail(orig.getCommentAuthorEmail());
        this.withCommentBody(orig.getCommentBody());
        this.withCommentBodyMatch(orig.getCommentBodyMatch());
        this.withCommitAuthorName(orig.getCommitAuthorName());
        this.withCommitAuthorEmail(orig.getCommitAuthorEmail());
        this.withCondRef(orig.getCondRef());
        this.withGitUrl(orig.getGitUrl());
        this.withSshUrl(orig.getSshUrl());
        this.withPollingLog(orig.getPollingLog());
    }

    public static GitHubPRCause newGitHubPRCause() {
        return new GitHubPRCause();
    }

    public GitHubPRCause withHeadSha(String headSha) {
        this.headSha = headSha;
        return this;
    }

    public GitHubPRCause withNumber(int number) {
        this.number = number;
        return this;
    }

    public GitHubPRCause withMergeable(boolean mergeable) {
        this.mergeable = mergeable;
        return this;
    }

    public GitHubPRCause withTargetBranch(String targetBranch) {
        this.targetBranch = targetBranch;
        return this;
    }

    public GitHubPRCause withSourceBranch(String sourceBranch) {
        this.sourceBranch = sourceBranch;
        return this;
    }

    public GitHubPRCause withPrAuthorEmail(String prAuthorEmail) {
        this.prAuthorEmail = prAuthorEmail;
        return this;
    }

    public GitHubPRCause withSourceRepoOwner(String sourceRepoOwner) {
        this.sourceRepoOwner = sourceRepoOwner;
        return this;
    }

    public GitHubPRCause withTriggerSenderName(String triggerSenderName) {
        this.triggerSenderName = triggerSenderName;
        return this;
    }

    public GitHubPRCause withTriggerSenderEmail(String triggerSenderEmail) {
        this.triggerSenderEmail = triggerSenderEmail;
        return this;
    }

    public GitHubPRCause withLabels(Set<String> labels) {
        this.labels = labels;
        return this;
    }

    public GitHubPRCause withCommitAuthorName(String commitAuthorName) {
        this.commitAuthorName = commitAuthorName;
        return this;
    }

    public GitHubPRCause withCommitAuthorEmail(String commitAuthorEmail) {
        this.commitAuthorEmail = commitAuthorEmail;
        return this;
    }

    public GitHubPRCause withCondRef(String condRef) {
        this.condRef = condRef;
        return this;
    }

    public GitHubPRCause withCommentAuthorName(String commentAuthorName) {
        this.commentAuthorName = commentAuthorName;
        return this;
    }

    public GitHubPRCause withCommentAuthorEmail(String commentAuthorEmail) {
        this.commentAuthorEmail = commentAuthorEmail;
        return this;
    }

    public GitHubPRCause withCommentBody(String commentBody) {
        this.commentBody = commentBody;
        return this;
    }

    public GitHubPRCause withCommentBodyMatch(String commentBodyMatch) {
        this.commentBodyMatch = commentBodyMatch;
        return this;
    }

    public String getBody() {
        return this.body;
    }

    public GitHubPRCause withBody(String body) {
        this.body = body;
        return this;
    }

    public String getShortDescription() {
        return "GitHub PR #" + this.number + ": " + this.getReason();
    }

    public String getHeadSha() {
        return this.headSha;
    }

    public boolean isMergeable() {
        return this.mergeable;
    }

    public int getNumber() {
        return this.number;
    }

    public String getTargetBranch() {
        return this.targetBranch;
    }

    public String getSourceBranch() {
        return this.sourceBranch;
    }

    public String getPRAuthorEmail() {
        return this.prAuthorEmail;
    }

    public String getSourceRepoOwner() {
        return this.sourceRepoOwner;
    }

    @NonNull
    public Set<String> getLabels() {
        return Objects.isNull(this.labels) ? Collections.emptySet() : this.labels;
    }

    public String getTriggerSenderName() {
        return this.triggerSenderName;
    }

    public String getTriggerSenderEmail() {
        return this.triggerSenderEmail;
    }

    public String getPrAuthorEmail() {
        return this.prAuthorEmail;
    }

    public String getCommitAuthorName() {
        return this.commitAuthorName;
    }

    public String getCommitAuthorEmail() {
        return this.commitAuthorEmail;
    }

    public String getState() {
        return this.state;
    }

    @NonNull
    public String getCondRef() {
        return this.condRef;
    }

    public String getCommentAuthorName() {
        return this.commentAuthorName;
    }

    public String getCommentAuthorEmail() {
        return this.commentAuthorEmail;
    }

    public String getCommentBody() {
        return this.commentBody;
    }

    public String getCommentBodyMatch() {
        return this.commentBodyMatch;
    }

    @Override
    public void fillParameters(List<ParameterValue> params) {
        GitHubPREnv.getParams(this, params);
    }

    @Override
    public GitHubSCMHead<GitHubPRCause> createSCMHead(String sourceId) {
        return new GitHubPRSCMHead(this.number, this.targetBranch, sourceId);
    }

    public void onAddedTo(@NonNull Run run) {
        if (run.getParent().getParent() instanceof SCMSourceOwner) {
            return;
        }
        try {
            GitHubPRPollingLogAction action = new GitHubPRPollingLogAction((Run<?, ?>)run);
            FileUtils.writeStringToFile((File)action.getPollingLogFile(), (String)this.getPollingLog());
            run.replaceAction((Action)action);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to persist the polling log", (Throwable)e);
        }
        this.setPollingLog(null);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)((Object)this), (Object)o, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)((Object)this), (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)((Object)this), (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

