/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.tag.events.impl;

import com.github.kostyasha.github.integration.generic.GitHubTagDecisionContext;
import com.github.kostyasha.github.integration.tag.GitHubTagCause;
import com.github.kostyasha.github.integration.tag.events.GitHubTagEvent;
import com.github.kostyasha.github.integration.tag.events.GitHubTagEventDescriptor;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.io.IOException;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jenkinsci.Symbol;
import org.kohsuke.github.GHTag;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubTagRestrictionFilter
extends GitHubTagEvent {
    private static final String DISPLAY_NAME = "Tag Restrictions";
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHubTagRestrictionFilter.class);
    private boolean exclude;
    private boolean matchAsPattern;
    private Set<String> matchCriteria;

    @DataBoundConstructor
    public GitHubTagRestrictionFilter() {
    }

    public String getMatchCriteriaStr() {
        return String.join((CharSequence)LINE_SEPARATOR, this.matchCriteria);
    }

    @DataBoundSetter
    public void setMatchCriteriaStr(String matchCriteria) {
        this.matchCriteria = Stream.of(matchCriteria.split(LINE_SEPARATOR)).collect(Collectors.toSet());
    }

    public boolean isExclude() {
        return this.exclude;
    }

    @DataBoundSetter
    public void setExclude(boolean exclude) {
        this.exclude = exclude;
    }

    public boolean isMatchAsPattern() {
        return this.matchAsPattern;
    }

    @DataBoundSetter
    public void setMatchAsPattern(boolean matchAsPattern) {
        this.matchAsPattern = matchAsPattern;
    }

    public Set<String> getMatchCriteria() {
        return this.matchCriteria;
    }

    @Override
    public GitHubTagCause check(@NonNull GitHubTagDecisionContext context) throws IOException {
        GHTag remoteTag = context.getRemoteTag();
        String name = remoteTag.getName();
        if (this.matchCriteria.isEmpty() || this.tagIsAllowed(name)) {
            if (this.matchCriteria.isEmpty()) {
                LOGGER.warn("Tag restriction filter added but no match criteria set, all tags allowed");
            }
            return null;
        }
        return this.toCause(context, true, "Tag [%s] filtered by tag name restriction filter", name);
    }

    private boolean tagIsAllowed(String name) {
        for (String pattern : this.matchCriteria) {
            LOGGER.trace("Checking tag [{}] against pattern [{}] - exclude [{}]", new Object[]{name, pattern, this.exclude});
            if (!this.matches(name, pattern)) continue;
            if (this.exclude) {
                LOGGER.debug("Tag [{}] matches pattern [{}], will be excluded", (Object)name, (Object)pattern);
                return false;
            }
            LOGGER.debug("Tag [%s] matched pattern [{}] and is marked for inclusion", (Object)name, (Object)pattern);
            return true;
        }
        LOGGER.trace("Tag [{}] matched no patterns, included [{}]", (Object)name, (Object)this.exclude);
        return this.exclude;
    }

    private boolean matches(String name, String pattern) {
        if (!this.matchAsPattern) {
            LOGGER.debug("Checking Tag [{}] against exact match [{}]", (Object)name, (Object)pattern);
            return name.equals(pattern);
        }
        try {
            LOGGER.debug("Checking tag [{}] against pattern [{}].", (Object)name, (Object)pattern);
            return Pattern.compile(pattern).matcher(name).matches();
        }
        catch (PatternSyntaxException e) {
            LOGGER.error("Invalid pattern [{}] detected checking tag [{}]", new Object[]{pattern, name, e});
            return false;
        }
    }

    private GitHubTagCause toCause(GitHubTagDecisionContext context, boolean skip, String message, Object ... args) {
        return context.newCause(String.format(message, args), skip);
    }

    @Symbol(value={"restrictions"})
    @Extension
    public static class Descriptor
    extends GitHubTagEventDescriptor {
        @NonNull
        public String getDisplayName() {
            return GitHubTagRestrictionFilter.DISPLAY_NAME;
        }
    }
}

