/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.tag.events.impl;

import com.github.kostyasha.github.integration.generic.GitHubTagDecisionContext;
import com.github.kostyasha.github.integration.tag.GitHubTag;
import com.github.kostyasha.github.integration.tag.GitHubTagCause;
import com.github.kostyasha.github.integration.tag.GitHubTagRepository;
import com.github.kostyasha.github.integration.tag.events.GitHubTagEvent;
import com.github.kostyasha.github.integration.tag.events.GitHubTagEventDescriptor;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Objects;
import org.jenkinsci.Symbol;
import org.kohsuke.github.GHTag;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubTagCreatedEvent
extends GitHubTagEvent {
    private static final String DISPLAY_NAME = "Tag Created";
    private static final Logger LOG = LoggerFactory.getLogger(GitHubTagCreatedEvent.class);

    @DataBoundConstructor
    public GitHubTagCreatedEvent() {
    }

    @Override
    public GitHubTagCause check(@NonNull GitHubTagDecisionContext context) throws IOException {
        GHTag remoteTag = context.getRemoteTag();
        GitHubTag localTag = context.getLocalTag();
        GitHubTagRepository localRepo = context.getLocalRepo();
        TaskListener listener = context.getListener();
        if (remoteTag == null && localTag == null) {
            LOG.debug("Remote and local tag are null");
            return null;
        }
        if (remoteTag == null) {
            LOG.debug("Remote tag is null for localTag '{}'. Tag can't be 'created'", (Object)localTag.getName());
            return null;
        }
        GitHubTagCause cause = null;
        if (Objects.isNull(localTag)) {
            PrintStream logger = listener.getLogger();
            logger.println("Tag Created: '" + remoteTag.getName() + "'");
            LOG.debug("{}: '{}'", (Object)DISPLAY_NAME, (Object)remoteTag.getName());
            cause = context.newCause(DISPLAY_NAME, false);
        }
        return cause;
    }

    @Symbol(value={"created"})
    @Extension
    public static class DescriptorImpl
    extends GitHubTagEventDescriptor {
        @NonNull
        public final String getDisplayName() {
            return GitHubTagCreatedEvent.DISPLAY_NAME;
        }
    }
}

