/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.tag;

import com.github.kostyasha.github.integration.generic.GitHubCause;
import com.github.kostyasha.github.integration.generic.GitHubTagDecisionContext;
import com.github.kostyasha.github.integration.multibranch.GitHubSCMSource;
import com.github.kostyasha.github.integration.multibranch.handler.GitHubTagHandler;
import com.github.kostyasha.github.integration.tag.GitHubTag;
import com.github.kostyasha.github.integration.tag.GitHubTagCause;
import com.github.kostyasha.github.integration.tag.GitHubTagRepository;
import com.github.kostyasha.github.integration.tag.events.GitHubTagEvent;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.kohsuke.github.GHTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagToCauseConverter
implements Function<GHTag, GitHubTagCause> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TagToCauseConverter.class);
    private final GitHubTagRepository localTags;
    private final TaskListener listener;
    private final GitHubTagHandler handler;
    private final GitHubSCMSource source;

    public TagToCauseConverter(@NonNull GitHubTagRepository localTags, @NonNull TaskListener listener, @NonNull GitHubTagHandler handler, @NonNull GitHubSCMSource source) {
        this.localTags = localTags;
        this.listener = listener;
        this.handler = handler;
        this.source = source;
    }

    private List<GitHubTagEvent> getEvents() {
        return this.handler.getEvents();
    }

    @Override
    public GitHubTagCause apply(GHTag remoteTag) {
        List causes = this.getEvents().stream().map(event -> this.toCause((GitHubTagEvent)((Object)event), remoteTag)).filter(Objects::nonNull).collect(Collectors.toList());
        String name = remoteTag.getName();
        if (causes.isEmpty()) {
            LOGGER.debug("No build trigger causes found for tag [{}].", (Object)name);
            return null;
        }
        LOGGER.debug("All matched events for tag [{}] : {}.", (Object)name, causes);
        GitHubTagCause cause = (GitHubTagCause)((Object)GitHubCause.skipTrigger(causes));
        if (cause != null) {
            LOGGER.debug("Cause [{}] indicated build should be skipped.", (Object)cause);
            this.listener.getLogger().println(String.format("Build of tag %s skipped: %s.", name, cause.getReason()));
            return null;
        }
        if (!causes.isEmpty()) {
            cause = (GitHubTagCause)((Object)causes.get(0));
            LOGGER.debug("Using build cause [{}] as trigger for tag [{}].", (Object)cause, (Object)name);
        }
        return cause;
    }

    private GitHubTagCause toCause(GitHubTagEvent event, GHTag remoteTag) {
        String tagName = remoteTag.getName();
        GitHubTag localTag = this.localTags.getTags().get(tagName);
        try {
            GitHubTagDecisionContext context = GitHubTagDecisionContext.newGitHubTagDecisionContext().withListener(this.listener).withLocalRepo(this.localTags).withRemoteTag(remoteTag).withLocalTag(localTag).withTagHandler(this.handler).withSCMSource(this.source).build();
            return context.checkEvent(event);
        }
        catch (IOException e) {
            LOGGER.error("Event check failed, skipping tag [{}].", (Object)tagName, (Object)e);
            this.listener.error("Event check failed, skipping tag [{}] {}", new Object[]{tagName, e});
            return null;
        }
    }
}

