/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.tag;

import com.github.kostyasha.github.integration.tag.GitHubTag;
import com.github.kostyasha.github.integration.tag.GitHubTagRepository;
import java.util.function.Function;
import org.kohsuke.github.GHTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalRepoUpdater
implements Function<GHTag, GHTag> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalRepoUpdater.class);
    private final GitHubTagRepository localRepo;

    private LocalRepoUpdater(GitHubTagRepository localRepo) {
        this.localRepo = localRepo;
    }

    public static LocalRepoUpdater updateLocalRepo(GitHubTagRepository localRepo) {
        return new LocalRepoUpdater(localRepo);
    }

    @Override
    public GHTag apply(GHTag remoteTag) {
        LOGGER.trace("Updating local branch repository with [{}]", (Object)remoteTag.getName());
        this.localRepo.getTags().put(remoteTag.getName(), new GitHubTag(remoteTag));
        return remoteTag;
    }
}

