/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.tag;

import com.github.kostyasha.github.integration.generic.GitHubRepository;
import com.github.kostyasha.github.integration.tag.GitHubTag;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.kohsuke.github.GHRepository;
import org.kohsuke.stapler.StaplerRequest;

public class GitHubTagRepository
extends GitHubRepository<GitHubTagRepository> {
    private Map<String, GitHubTag> tags = new ConcurrentHashMap<String, GitHubTag>();

    public GitHubTagRepository(GHRepository remoteRepository) throws IOException {
        super(remoteRepository);
    }

    public GitHubTagRepository(String repoFullName, URL url) {
        super(repoFullName, url);
    }

    @NonNull
    public Map<String, GitHubTag> getTags() {
        if (Objects.isNull(this.tags)) {
            this.tags = new ConcurrentHashMap<String, GitHubTag>();
        }
        return this.tags;
    }

    public String getIconFileName() {
        return GitHubTag.getIconFileName();
    }

    public String getDisplayName() {
        return "GitHub Tags";
    }

    public String getUrlName() {
        return "github-tag";
    }

    @Override
    public void actualiseOnChange(@NonNull GHRepository ghRepository, @NonNull TaskListener listener) {
        if (this.changed) {
            listener.getLogger().println("Local settings changed, removing tags in repository state!");
            this.getTags().clear();
        }
    }

    @Override
    public FormValidation doClearRepo() throws IOException {
        return FormValidation.ok();
    }

    @Override
    public FormValidation doRunTrigger() throws IOException {
        return FormValidation.ok();
    }

    @Override
    public FormValidation doRebuildAllFailed() throws IOException {
        return FormValidation.ok();
    }

    @Override
    public FormValidation doBuild(StaplerRequest req) throws IOException {
        return FormValidation.ok();
    }

    @Override
    public FormValidation doRebuild(StaplerRequest req) throws IOException {
        return FormValidation.ok();
    }
}

