/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.tag;

import com.github.kostyasha.github.integration.branch.AbstractGitHubBranchCause;
import com.github.kostyasha.github.integration.generic.GitHubCause;
import com.github.kostyasha.github.integration.generic.GitHubEnv;
import com.github.kostyasha.github.integration.generic.GitHubRepoEnv;
import com.github.kostyasha.github.integration.tag.GitHubTagCause;
import hudson.model.ParameterValue;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;

public enum GitHubTagEnv implements GitHubEnv<GitHubTagCause>
{
    NAME(GitHubTagCause::getTagName),
    SHORT_DESC(GitHubTagCause::getShortDescription),
    TITLE(GitHubCause::getTitle),
    URL(c -> c.getHtmlUrl().toString()),
    HEAD_SHA(AbstractGitHubBranchCause::getCommitSha),
    FULL_REF(AbstractGitHubBranchCause::getFullRef),
    CAUSE_SKIP(GitHubCause::isSkip);

    public static final String PREFIX = "GITHUB_TAG_";
    private Function<GitHubTagCause, ParameterValue> fun;

    private GitHubTagEnv(Function<GitHubTagCause, String> fun) {
        this.fun = c -> this.param((String)fun.apply((GitHubTagCause)((Object)c)));
    }

    private GitHubTagEnv(Predicate<GitHubTagCause> fun) {
        this.fun = c -> this.param(fun.test((GitHubTagCause)((Object)c)));
    }

    @Override
    public void addParam(GitHubTagCause cause, List<ParameterValue> params) {
        params.add(this.fun.apply(cause));
    }

    public String toString() {
        return PREFIX.concat(this.name());
    }

    public static void getParams(GitHubTagCause cause, List<ParameterValue> params) {
        GitHubEnv.getParams(GitHubTagEnv.class, cause, params);
        GitHubEnv.getParams(GitHubRepoEnv.class, cause, params);
    }
}

