/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.tag;

import com.github.kostyasha.github.integration.branch.AbstractGitHubBranchCause;
import com.github.kostyasha.github.integration.multibranch.head.GitHubSCMHead;
import com.github.kostyasha.github.integration.multibranch.head.GitHubTagSCMHead;
import com.github.kostyasha.github.integration.tag.GitHubTag;
import com.github.kostyasha.github.integration.tag.GitHubTagEnv;
import com.github.kostyasha.github.integration.tag.GitHubTagRepository;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.ParameterValue;
import java.util.List;
import org.kohsuke.github.GHTag;

public class GitHubTagCause
extends AbstractGitHubBranchCause<GitHubTagCause> {
    private final String tagName;

    public GitHubTagCause(@NonNull GitHubTag localTag, @NonNull GitHubTagRepository localRepo, String reason, boolean skip) {
        this(localTag.getName(), localTag.getCommitSha());
        this.withReason(reason);
        this.withSkip(skip);
        this.withLocalRepo(localRepo);
    }

    public GitHubTagCause(@NonNull GHTag remoteTag, @NonNull GitHubTagRepository localRepo, String reason, boolean skip) {
        this(remoteTag.getName(), remoteTag.getCommit().getSHA1());
        this.withReason(reason);
        this.withSkip(skip);
        this.withLocalRepo(localRepo);
        this.withRemoteData(remoteTag);
    }

    public GitHubTagCause(@NonNull String tagName, String commitSha) {
        super(commitSha, "refs/tags/" + tagName);
        this.tagName = tagName;
    }

    public GitHubTagCause(GitHubTagCause cause) {
        super(cause);
        this.tagName = cause.getTagName();
    }

    public String getTagName() {
        return this.tagName;
    }

    @NonNull
    public String getShortDescription() {
        if (this.getHtmlUrl() != null) {
            return "GitHub tag " + this.getTagName() + ": " + this.getReason();
        }
        return "Deleted tag";
    }

    @Override
    public void fillParameters(List<ParameterValue> params) {
        GitHubTagEnv.getParams(this, params);
    }

    @Override
    public GitHubSCMHead<GitHubTagCause> createSCMHead(String sourceId) {
        return new GitHubTagSCMHead(this.tagName, sourceId);
    }
}

