/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.tag;

import com.github.kostyasha.github.integration.branch.GitHubBranch;
import hudson.Functions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHTag;

public class GitHubTag
extends GitHubBranch {
    public GitHubTag(GHTag ghTag) {
        this(ghTag.getName(), ghTag.getCommit().getSHA1(), ghTag.getOwner());
    }

    public GitHubTag(String name, String commitSha, GHRepository ghRepository) {
        super(name, commitSha, ghRepository);
    }

    public static String getIconFileName() {
        return Functions.getResourcePath() + "/plugin/github-pullrequest/git-tag.svg";
    }

    public static GHTag findRemoteTag(GHRepository repo, String name) throws IOException {
        Stream<GHTag> tagStream = StreamSupport.stream(repo.listTags().spliterator(), false);
        return tagStream.filter(t -> t.getName().equals(name)).findFirst().orElse(null);
    }

    public static List<GHTag> getAllTags(GHRepository repo) throws IOException {
        ArrayList<GHTag> tags = new ArrayList<GHTag>();
        repo.listTags().forEach(tags::add);
        return tags;
    }
}

