/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.multibranch.repoprovider;

import com.cloudbees.jenkins.GitHubRepositoryName;
import com.cloudbees.jenkins.GitHubWebHook;
import com.github.kostyasha.github.integration.generic.repoprovider.GHPermission;
import com.github.kostyasha.github.integration.multibranch.GitHubSCMSource;
import com.github.kostyasha.github.integration.multibranch.repoprovider.GitHubRepoProvider2;
import com.google.common.base.Optional;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import java.io.IOException;
import java.util.Objects;
import org.apache.commons.lang3.BooleanUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.github.GitHubPlugin;
import org.jenkinsci.plugins.github.config.GitHubServerConfig;
import org.jenkinsci.plugins.github.internal.GHPluginConfigException;
import org.jenkinsci.plugins.github.util.FluentIterableWrapper;
import org.jenkinsci.plugins.github.util.misc.NullSafePredicate;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubPluginRepoProvider2
extends GitHubRepoProvider2 {
    private static final Logger LOG = LoggerFactory.getLogger(GitHubPluginRepoProvider2.class);
    protected Boolean cacheConnection = true;
    private Boolean manageHooks = true;
    private GHPermission repoPermission = GHPermission.ADMIN;
    private transient GHRepository remoteRepository;
    private transient GitHub gitHub;

    @DataBoundConstructor
    public GitHubPluginRepoProvider2() {
    }

    public boolean isCacheConnection() {
        return BooleanUtils.isNotFalse((Boolean)this.cacheConnection);
    }

    @DataBoundSetter
    public void setCacheConnection(boolean cacheConnection) {
        this.cacheConnection = cacheConnection;
    }

    public boolean isManageHooks() {
        return BooleanUtils.isTrue((Boolean)this.manageHooks);
    }

    @DataBoundSetter
    public void setManageHooks(boolean manageHooks) {
        this.manageHooks = manageHooks;
    }

    public GHPermission getRepoPermission() {
        return this.repoPermission;
    }

    @DataBoundSetter
    public void setRepoPermission(GHPermission repoPermission) {
        this.repoPermission = repoPermission;
    }

    @Override
    public void registerHookFor(GitHubSCMSource source) {
        GitHubWebHook.get().registerHookFor((Item)source.getOwner());
    }

    @Override
    public boolean isManageHooks(GitHubSCMSource source) {
        return this.isManageHooks() && GitHubPlugin.configuration().isManageHooks();
    }

    @Override
    @NonNull
    public synchronized GitHub getGitHub(GitHubSCMSource source) {
        if (BooleanUtils.isTrue((Boolean)this.cacheConnection) && Objects.nonNull(this.gitHub)) {
            return this.gitHub;
        }
        GitHubRepositoryName repoFullName = source.getRepoFullName();
        Optional client = FluentIterableWrapper.from((Iterable)GitHubPlugin.configuration().findGithubConfig(GitHubServerConfig.withHost((String)repoFullName.getHost()))).firstMatch(this.withPermission(repoFullName, this.getRepoPermission()));
        if (client.isPresent()) {
            this.gitHub = (GitHub)client.get();
            return this.gitHub;
        }
        throw new GHPluginConfigException("GitHubPluginRepoProvider can't find appropriate client for github repo <%s>. Probably you didn't configure 'GitHub Plugin' global 'GitHub Server Settings' or there is no tokenswith %s access to this repository.", new Object[]{repoFullName.toString(), this.getRepoPermission()});
    }

    private NullSafePredicate<GitHub> withPermission(final GitHubRepositoryName name, final GHPermission permission) {
        return new NullSafePredicate<GitHub>(){

            protected boolean applyNullSafe(@NonNull GitHub gh) {
                try {
                    GHRepository repo = gh.getRepository(name.getUserName() + "/" + name.getRepositoryName());
                    if (permission == GHPermission.ADMIN) {
                        return repo.hasAdminAccess();
                    }
                    if (permission == GHPermission.PUSH) {
                        return repo.hasPushAccess();
                    }
                    return repo.hasPullAccess();
                }
                catch (IOException e) {
                    return false;
                }
            }
        };
    }

    @Override
    @CheckForNull
    public synchronized GHRepository getGHRepository(GitHubSCMSource source) {
        if (BooleanUtils.isTrue((Boolean)this.cacheConnection) && Objects.nonNull(this.remoteRepository)) {
            return this.remoteRepository;
        }
        GitHubRepositoryName name = source.getRepoFullName();
        try {
            this.remoteRepository = this.getGitHub(source).getRepository(name.getUserName() + "/" + name.getRepositoryName());
        }
        catch (IOException ex) {
            LOG.error("Shouldn't fail because getGitHub() expected to provide working repo.", (Throwable)ex);
        }
        return this.remoteRepository;
    }

    protected Object readResolve() {
        if (Objects.isNull(this.cacheConnection)) {
            this.cacheConnection = true;
        }
        if (Objects.isNull((Object)this.repoPermission)) {
            this.repoPermission = GHPermission.ADMIN;
        }
        if (Objects.isNull(this.manageHooks)) {
            this.manageHooks = true;
        }
        return this;
    }

    public GitHubPluginRepoProviderDescriptor2 getDescriptor() {
        return (GitHubPluginRepoProviderDescriptor2)super.getDescriptor();
    }

    @Symbol(value={"gitHubPlugin"})
    @Extension
    public static class GitHubPluginRepoProviderDescriptor2
    extends GitHubRepoProvider2.GitHubRepoProviderDescriptor2 {
        @Override
        @NonNull
        public String getDisplayName() {
            return "GitHub Plugin from Global Settings";
        }
    }
}

