/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.multibranch.hooks;

import com.cloudbees.jenkins.GitHubRepositoryName;
import com.github.kostyasha.github.integration.multibranch.GitHubSCMSource;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.scm.SCM;
import java.util.Objects;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMSource;

public abstract class GitHubScmHeadEvent<T>
extends SCMHeadEvent<T> {
    protected GitHubScmHeadEvent(SCMEvent.Type type, long timestamp, T payload, String origin) {
        super(type, timestamp, payload, origin);
    }

    @NonNull
    protected abstract String getSourceRepo();

    public boolean isMatch(@NonNull SCMSource source) {
        if (!(source instanceof GitHubSCMSource)) {
            return false;
        }
        return this.getSourceRepo().equals(this.getSourceRepo(source));
    }

    @NonNull
    public String getSourceName() {
        return this.getSourceRepo();
    }

    @CheckForNull
    protected String getSourceRepo(@NonNull SCMSource source) {
        GitHubSCMSource gitHubSCMSource = (GitHubSCMSource)source;
        String projectUrlStr = gitHubSCMSource.getProjectUrlStr();
        GitHubRepositoryName repo = GitHubRepositoryName.create((String)projectUrlStr);
        return Objects.isNull(repo) ? null : String.format("%s/%s", repo.getUserName(), repo.getRepositoryName());
    }

    public boolean isMatch(SCMNavigator navigator) {
        return false;
    }

    public boolean isMatch(SCM scm) {
        return false;
    }
}

