/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.multibranch.hooks;

import com.github.kostyasha.github.integration.multibranch.GitHubSCMSource;
import com.github.kostyasha.github.integration.multibranch.handler.GitHubHandler;
import com.github.kostyasha.github.integration.multibranch.handler.GitHubPRHandler;
import com.github.kostyasha.github.integration.multibranch.hooks.GitHubPullRequestScmHeadEvent;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.Item;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceOwner;
import org.jenkinsci.plugins.github.extension.GHSubscriberEvent;
import org.jenkinsci.plugins.github.pullrequest.webhook.AbstractGHPullRequestSubsriber;
import org.jenkinsci.plugins.github.pullrequest.webhook.PullRequestInfo;
import org.kohsuke.github.GitHub;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class GHPRMultiBranchSubscriber
extends AbstractGHPullRequestSubsriber {
    public static final Logger LOG = LoggerFactory.getLogger(GHPRMultiBranchSubscriber.class);

    protected boolean isApplicable(@Nullable Item item) {
        if (item instanceof SCMSourceOwner) {
            SCMSourceOwner scmSourceOwner = (SCMSourceOwner)item;
            for (SCMSource source : scmSourceOwner.getSCMSources()) {
                if (!(source instanceof GitHubSCMSource)) continue;
                GitHubSCMSource gitHubSCMSource = (GitHubSCMSource)source;
                for (GitHubHandler hubHandler : gitHubSCMSource.getHandlers()) {
                    if (!(hubHandler instanceof GitHubPRHandler)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected void onEvent(GHSubscriberEvent event) {
        try {
            GitHub gh = GitHub.offline();
            PullRequestInfo ref = this.extractPullRequestInfo(event.getGHEvent(), (String)event.getPayload(), gh);
            SCMHeadEvent.fireNow((SCMHeadEvent)new GitHubPullRequestScmHeadEvent(SCMEvent.Type.UPDATED, event.getTimestamp(), ref, ref.getRepo()));
        }
        catch (Exception e) {
            LOG.error("Can't process {} hook", (Object)event, (Object)e);
        }
    }
}

