/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.multibranch.head;

import com.github.kostyasha.github.integration.multibranch.head.GitHubSCMHead;
import com.github.kostyasha.github.integration.tag.GitHubTag;
import com.github.kostyasha.github.integration.tag.GitHubTagCause;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHTag;

public class GitHubTagSCMHead
extends GitHubSCMHead<GitHubTagCause> {
    private static final long serialVersionUID = 1L;

    public GitHubTagSCMHead(@NonNull String name, String sourceId) {
        super(name, sourceId);
    }

    public String getPronoun() {
        return "Tag " + this.getName();
    }

    @Override
    public String fetchHeadSha(GHRepository remoteRepo) throws IOException {
        GHTag tag = GitHubTag.findRemoteTag(remoteRepo, this.getName());
        if (tag == null) {
            throw new IOException("No tag " + this.getName() + " in " + remoteRepo.getFullName());
        }
        return tag.getCommit().getSHA1();
    }

    @Override
    public String getHeadSha(GitHubTagCause cause) {
        return cause.getCommitSha();
    }
}

