/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.multibranch.head;

import com.github.kostyasha.github.integration.multibranch.head.GitHubSCMHead;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRCause;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;

public class GitHubPRSCMHead
extends GitHubSCMHead<GitHubPRCause> {
    private static final long serialVersionUID = 1L;
    private final int prNumber;
    private final String targetBranch;

    public GitHubPRSCMHead(@NonNull GitHubPRCause prCause, String sourceId) {
        this(prCause.getNumber(), prCause.getTargetBranch(), sourceId);
    }

    public GitHubPRSCMHead(@NonNull Integer prNumber, @NonNull String targetBranch, String sourceId) {
        super("pr-" + Integer.toString(prNumber), sourceId);
        this.prNumber = prNumber;
        this.targetBranch = targetBranch;
    }

    public int getPrNumber() {
        return this.prNumber;
    }

    public String getTargetBranch() {
        return this.targetBranch;
    }

    public String getPronoun() {
        return "PR#" + this.prNumber;
    }

    @Override
    public String fetchHeadSha(GHRepository remoteRepo) throws IOException {
        GHPullRequest pullRequest = remoteRepo.getPullRequest(this.prNumber);
        if (pullRequest == null) {
            throw new IOException("No PR " + this.prNumber + " in " + remoteRepo.getFullName());
        }
        return pullRequest.getHead().getSha();
    }

    @Override
    public String getHeadSha(GitHubPRCause cause) {
        return cause.getHeadSha();
    }
}

