/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.multibranch.head;

import com.github.kostyasha.github.integration.branch.GitHubBranchCause;
import com.github.kostyasha.github.integration.multibranch.head.GitHubSCMHead;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import org.kohsuke.github.GHBranch;
import org.kohsuke.github.GHRepository;

public class GitHubBranchSCMHead
extends GitHubSCMHead<GitHubBranchCause> {
    private static final long serialVersionUID = 1L;

    public GitHubBranchSCMHead(@NonNull String name, String sourceId) {
        super(name, sourceId);
    }

    public String getPronoun() {
        return "Branch " + this.getName();
    }

    @Override
    public String fetchHeadSha(GHRepository remoteRepo) throws IOException {
        GHBranch branch = remoteRepo.getBranch(this.getName());
        if (branch == null) {
            throw new IOException("No branch " + this.getName() + " in " + remoteRepo.getFullName());
        }
        return branch.getSHA1();
    }

    @Override
    public String getHeadSha(GitHubBranchCause cause) {
        return cause.getCommitSha();
    }
}

