/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.multibranch.handler;

import com.github.kostyasha.github.integration.branch.webhook.BranchInfo;
import com.github.kostyasha.github.integration.multibranch.GitHubSCMSource;
import com.github.kostyasha.github.integration.multibranch.handler.GitHubHandler;
import com.github.kostyasha.github.integration.multibranch.handler.GitHubHandlerDescriptor;
import com.github.kostyasha.github.integration.multibranch.handler.GitHubSourceContext;
import com.github.kostyasha.github.integration.multibranch.hooks.GitHubTagSCMHeadEvent;
import com.github.kostyasha.github.integration.tag.GitHubTag;
import com.github.kostyasha.github.integration.tag.GitHubTagCause;
import com.github.kostyasha.github.integration.tag.GitHubTagRepository;
import com.github.kostyasha.github.integration.tag.LocalRepoUpdater;
import com.github.kostyasha.github.integration.tag.TagToCauseConverter;
import com.github.kostyasha.github.integration.tag.events.GitHubTagEvent;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import jenkins.scm.api.SCMHeadEvent;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.github.pullrequest.utils.IOUtils;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHTag;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class GitHubTagHandler
extends GitHubHandler {
    private List<GitHubTagEvent> events = new ArrayList<GitHubTagEvent>();

    @DataBoundConstructor
    public GitHubTagHandler() {
    }

    public List<GitHubTagEvent> getEvents() {
        return this.events;
    }

    @DataBoundSetter
    public GitHubTagHandler setEvents(List<GitHubTagEvent> events) {
        this.events = events;
        return this;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Override
    public void handle(@NonNull GitHubSourceContext context) throws IOException {
        Stream<Object> tags;
        String tagName;
        SCMHeadEvent<?> scmHeadEvent = context.getScmHeadEvent();
        if (scmHeadEvent instanceof GitHubTagSCMHeadEvent) {
            BranchInfo info = (BranchInfo)scmHeadEvent.getPayload();
            tagName = info.getBranchName();
        } else {
            if (scmHeadEvent != null) {
                return;
            }
            tagName = null;
        }
        TaskListener listener = context.getListener();
        GHRepository remoteRepo = context.getRemoteRepo();
        GitHubTagRepository localRepo = Objects.requireNonNull(context.getLocalRepo().getTagRepository());
        GitHubTagRepository oldRepo = new GitHubTagRepository(remoteRepo);
        oldRepo.getTags().putAll(localRepo.getTags());
        if (tagName != null) {
            listener.getLogger().println("**** Processing tag " + tagName + " ****");
            tags = IOUtils.ioOptStream(() -> GitHubTag.findRemoteTag(remoteRepo, tagName));
            localRepo.getTags().remove(tagName);
        } else {
            listener.getLogger().println("**** Processing all tags ****");
            tags = GitHubTag.getAllTags(remoteRepo).stream();
            localRepo.getTags().clear();
        }
        this.processCauses(context, tags.filter(IOUtils.iop(t -> context.checkCriteria(new GitHubTagCause((GHTag)t, localRepo, "Check", false)))).map(LocalRepoUpdater.updateLocalRepo(localRepo)).map(this.toCause(context, oldRepo)));
        listener.getLogger().println("**** Done processing tags ****");
    }

    private Function<GHTag, GitHubTagCause> toCause(GitHubSourceContext context, GitHubTagRepository localRepo) {
        TaskListener listener = context.getListener();
        GitHubSCMSource source = context.getSource();
        return t -> {
            GitHubTagCause c = new TagToCauseConverter(localRepo, listener, this, source).apply((GHTag)t);
            if (c == null) {
                c = new GitHubTagCause((GHTag)t, localRepo, "Skip", true);
            }
            return c;
        };
    }

    @Symbol(value={"tags", "tag"})
    @Extension
    public static class DescriptorImpl
    extends GitHubHandlerDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Tags Handler";
        }
    }
}

