/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.multibranch.handler;

import com.github.kostyasha.github.integration.generic.GitHubCause;
import com.github.kostyasha.github.integration.multibranch.GitHubSCMSource;
import com.github.kostyasha.github.integration.multibranch.action.GitHubRepo;
import com.github.kostyasha.github.integration.multibranch.revision.GitHubSCMRevision;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.Job;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Objects;
import jenkins.branch.BranchProjectFactory;
import jenkins.branch.MultiBranchProject;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceOwner;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;

public class GitHubSourceContext {
    private final GitHubSCMSource source;
    private final SCMHeadObserver observer;
    private final SCMSourceCriteria criteria;
    private final SCMHeadEvent<?> scmHeadEvent;
    private final GitHubRepo localRepo;
    private final GHRepository remoteRepo;
    private final TaskListener listener;

    public GitHubSourceContext(@NonNull GitHubSCMSource source, @NonNull SCMHeadObserver observer, @NonNull SCMSourceCriteria criteria, @Nullable SCMHeadEvent<?> scmHeadEvent, @NonNull GitHubRepo localRepo, @NonNull GHRepository remoteRepo, @NonNull TaskListener listener) {
        this.source = source;
        this.observer = observer;
        this.criteria = criteria;
        this.scmHeadEvent = scmHeadEvent;
        this.localRepo = localRepo;
        this.remoteRepo = remoteRepo;
        this.listener = listener;
    }

    @NonNull
    public GitHubSCMSource getSource() {
        return this.source;
    }

    @NonNull
    public SCMHeadObserver getObserver() {
        return this.observer;
    }

    public SCMHeadEvent<?> getScmHeadEvent() {
        return this.scmHeadEvent;
    }

    @NonNull
    public GitHubRepo getLocalRepo() {
        return this.localRepo;
    }

    @NonNull
    public GHRepository getRemoteRepo() {
        return this.remoteRepo;
    }

    @NonNull
    public TaskListener getListener() {
        return this.listener;
    }

    public GitHub getGitHub() {
        return this.source.getRepoProvider().getGitHub(this.source);
    }

    public boolean checkCriteria(@NonNull GitHubCause<?> cause) throws IOException {
        if (Objects.nonNull(this.criteria)) {
            GitHubSCMRevision revision = cause.createSCMRevision(this.source.getId());
            this.listener.getLogger().println("");
            this.listener.getLogger().println("Checking " + revision.getHead().getPronoun());
            if (!this.criteria.isHead((SCMSourceCriteria.Probe)this.source.newProbe(revision.getHead(), (SCMRevision)revision), this.listener)) {
                this.listener.getLogger().println("  Didn't meet criteria");
                return false;
            }
            this.listener.getLogger().println("  Met criteria");
        }
        return true;
    }

    public void observe(@NonNull GitHubCause<?> cause) {
        try {
            GitHubSCMRevision scmRevision = cause.createSCMRevision(this.source.getId());
            if (!cause.isSkip()) {
                this.forceScheduling(scmRevision);
            }
            this.getObserver().observe(scmRevision.getHead(), (SCMRevision)scmRevision);
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace(this.listener.getLogger());
        }
    }

    private void forceScheduling(GitHubSCMRevision scmRevision) throws IOException {
        SCMSourceOwner owner = this.source.getOwner();
        if (owner instanceof MultiBranchProject) {
            SCMRevision rev;
            MultiBranchProject mb = (MultiBranchProject)owner;
            BranchProjectFactory pf = mb.getProjectFactory();
            SCMHead scmHead = scmRevision.getHead();
            Job j = mb.getItemByBranchName(scmHead.getName());
            if (j != null && (rev = pf.getRevision(j)) != null && rev.equals((Object)scmRevision)) {
                pf.setRevisionHash(j, (SCMRevision)new DummyRevision(scmHead));
            }
        }
    }

    public static class DummyRevision
    extends SCMRevision {
        private static final long serialVersionUID = 1L;

        public DummyRevision(SCMHead head) {
            super(head);
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            return false;
        }
    }
}

