/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.multibranch.handler;

import com.github.kostyasha.github.integration.generic.utils.RetryableGitHubOperation;
import com.github.kostyasha.github.integration.multibranch.GitHubSCMSource;
import com.github.kostyasha.github.integration.multibranch.handler.GitHubHandler;
import com.github.kostyasha.github.integration.multibranch.handler.GitHubHandlerDescriptor;
import com.github.kostyasha.github.integration.multibranch.handler.GitHubSourceContext;
import com.github.kostyasha.github.integration.multibranch.hooks.GitHubPullRequestScmHeadEvent;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jenkins.scm.api.SCMHeadEvent;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRCause;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRRepository;
import org.jenkinsci.plugins.github.pullrequest.events.GitHubPREvent;
import org.jenkinsci.plugins.github.pullrequest.trigger.check.LocalRepoUpdater;
import org.jenkinsci.plugins.github.pullrequest.trigger.check.PullRequestToCauseConverter;
import org.jenkinsci.plugins.github.pullrequest.trigger.check.SkipPRInBadState;
import org.jenkinsci.plugins.github.pullrequest.utils.IOUtils;
import org.jenkinsci.plugins.github.pullrequest.webhook.PullRequestInfo;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class GitHubPRHandler
extends GitHubHandler {
    @CheckForNull
    private List<GitHubPREvent> events = new ArrayList<GitHubPREvent>();

    @DataBoundConstructor
    public GitHubPRHandler() {
    }

    public List<GitHubPREvent> getEvents() {
        return this.events;
    }

    @DataBoundSetter
    public GitHubPRHandler setEvents(List<GitHubPREvent> events) {
        this.events = events;
        return this;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Override
    public void handle(@NonNull GitHubSourceContext context) throws IOException {
        Stream<GHPullRequest> pulls;
        Integer prNumber;
        SCMHeadEvent<?> scmHeadEvent = context.getScmHeadEvent();
        if (scmHeadEvent instanceof GitHubPullRequestScmHeadEvent) {
            PullRequestInfo info = (PullRequestInfo)scmHeadEvent.getPayload();
            prNumber = info.getNum();
        } else {
            if (scmHeadEvent != null) {
                return;
            }
            prNumber = null;
        }
        TaskListener listener = context.getListener();
        GHRepository remoteRepo = context.getRemoteRepo();
        GitHubPRRepository localRepo = Objects.requireNonNull(context.getLocalRepo().getPrRepository());
        GitHubPRRepository oldRepo = new GitHubPRRepository(remoteRepo);
        oldRepo.getPulls().putAll(localRepo.getPulls());
        if (prNumber != null) {
            listener.getLogger().println("**** Processing pull request #" + prNumber + " ****");
            pulls = IOUtils.ioOptStream(() -> RetryableGitHubOperation.execute(() -> remoteRepo.getPullRequest(prNumber.intValue())));
            localRepo.getPulls().remove(prNumber);
        } else {
            listener.getLogger().println("**** Processing all pull requests ****");
            pulls = GitHubPRHandler.fetchRemotePRs(localRepo, remoteRepo);
            localRepo.getPulls().clear();
        }
        this.processCauses(context, pulls.filter(IOUtils.iop(pr -> context.checkCriteria(new GitHubPRCause((GHPullRequest)pr, localRepo, "Check", false)))).map(LocalRepoUpdater.updateLocalRepo(localRepo)).filter(SkipPRInBadState.badState(localRepo, listener)).map(this.toCause(context, oldRepo)));
        listener.getLogger().println("**** Done processing pull requests ****");
    }

    private Function<GHPullRequest, GitHubPRCause> toCause(GitHubSourceContext context, GitHubPRRepository localRepo) {
        TaskListener listener = context.getListener();
        GitHubSCMSource source = context.getSource();
        return pr -> {
            GitHubPRCause c = PullRequestToCauseConverter.toGitHubPRCause(localRepo, listener, this, source).apply((GHPullRequest)pr);
            if (c == null) {
                c = new GitHubPRCause((GHPullRequest)pr, localRepo, "Skip", true);
            }
            return c;
        };
    }

    private static Stream<GHPullRequest> fetchRemotePRs(GitHubPRRepository localRepo, GHRepository remoteRepo) throws IOException {
        Map remotePulls = RetryableGitHubOperation.execute(() -> remoteRepo.getPullRequests(GHIssueState.OPEN)).stream().collect(Collectors.toMap(GHIssue::getNumber, Function.identity()));
        Stream<GHPullRequest> closed = new HashSet<Integer>(localRepo.getPulls().keySet()).stream().filter(pr -> !remotePulls.containsKey(pr)).map(IOUtils.iof(arg_0 -> ((GHRepository)remoteRepo).getPullRequest(arg_0)));
        return Stream.concat(remotePulls.values().stream(), closed);
    }

    @Symbol(value={"pullRequests", "pullRequest"})
    @Extension
    public static class DescriptorImpl
    extends GitHubHandlerDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Pull Requests Handler";
        }
    }
}

