/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.multibranch.handler;

import com.github.kostyasha.github.integration.branch.GitHubBranchCause;
import com.github.kostyasha.github.integration.branch.GitHubBranchRepository;
import com.github.kostyasha.github.integration.branch.events.GitHubBranchEvent;
import com.github.kostyasha.github.integration.branch.trigger.check.BranchToCauseConverter;
import com.github.kostyasha.github.integration.branch.trigger.check.LocalRepoUpdater;
import com.github.kostyasha.github.integration.branch.webhook.BranchInfo;
import com.github.kostyasha.github.integration.multibranch.GitHubSCMSource;
import com.github.kostyasha.github.integration.multibranch.handler.GitHubHandler;
import com.github.kostyasha.github.integration.multibranch.handler.GitHubHandlerDescriptor;
import com.github.kostyasha.github.integration.multibranch.handler.GitHubSourceContext;
import com.github.kostyasha.github.integration.multibranch.hooks.GitHubBranchSCMHeadEvent;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import jenkins.scm.api.SCMHeadEvent;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.github.pullrequest.utils.IOUtils;
import org.kohsuke.github.GHBranch;
import org.kohsuke.github.GHRepository;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class GitHubBranchHandler
extends GitHubHandler {
    private List<GitHubBranchEvent> events = new ArrayList<GitHubBranchEvent>();

    @DataBoundConstructor
    public GitHubBranchHandler() {
    }

    public List<GitHubBranchEvent> getEvents() {
        return this.events;
    }

    @DataBoundSetter
    public GitHubBranchHandler setEvents(List<GitHubBranchEvent> events) {
        this.events = events;
        return this;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Override
    public void handle(@NonNull GitHubSourceContext context) throws IOException {
        Stream<GHBranch> branches;
        String branchName;
        SCMHeadEvent<?> scmHeadEvent = context.getScmHeadEvent();
        if (scmHeadEvent instanceof GitHubBranchSCMHeadEvent) {
            BranchInfo info = (BranchInfo)scmHeadEvent.getPayload();
            branchName = info.getBranchName();
        } else {
            if (scmHeadEvent != null) {
                return;
            }
            branchName = null;
        }
        TaskListener listener = context.getListener();
        GHRepository remoteRepo = context.getRemoteRepo();
        GitHubBranchRepository localRepo = Objects.requireNonNull(context.getLocalRepo().getBranchRepository());
        GitHubBranchRepository oldRepo = new GitHubBranchRepository(remoteRepo);
        oldRepo.getBranches().putAll(localRepo.getBranches());
        if (branchName != null) {
            listener.getLogger().println("**** Processing branch " + branchName + " ****");
            branches = IOUtils.ioOptStream(() -> remoteRepo.getBranch(branchName));
            localRepo.getBranches().remove(branchName);
        } else {
            listener.getLogger().println("**** Processing all branches ****");
            branches = this.fetchRemoteBranches(remoteRepo).values().stream();
            localRepo.getBranches().clear();
        }
        this.processCauses(context, branches.filter(IOUtils.iop(b -> context.checkCriteria(new GitHubBranchCause((GHBranch)b, localRepo, "Check", false)))).map(LocalRepoUpdater.updateLocalRepo(localRepo)).map(this.toCause(context, oldRepo)));
        listener.getLogger().println("**** Done processing branches ****");
    }

    private Function<GHBranch, GitHubBranchCause> toCause(GitHubSourceContext context, GitHubBranchRepository localRepo) {
        TaskListener listener = context.getListener();
        GitHubSCMSource source = context.getSource();
        return b -> {
            GitHubBranchCause c = BranchToCauseConverter.toGitHubBranchCause(localRepo, listener, this, source).apply((GHBranch)b);
            if (c == null) {
                c = new GitHubBranchCause((GHBranch)b, localRepo, "Skip", true);
            }
            return c;
        };
    }

    private Map<String, GHBranch> fetchRemoteBranches(GHRepository remoteRepo) throws IOException {
        String defName;
        Map branches = remoteRepo.getBranches();
        GHBranch def = (GHBranch)branches.get(defName = remoteRepo.getDefaultBranch());
        if (def == null) {
            return branches;
        }
        LinkedHashMap<String, GHBranch> ordered = new LinkedHashMap<String, GHBranch>();
        ordered.put(defName, def);
        branches.entrySet().forEach(e -> {
            if (!((String)e.getKey()).equals(defName)) {
                ordered.put((String)e.getKey(), (GHBranch)e.getValue());
            }
        });
        return ordered;
    }

    @Symbol(value={"branches"})
    @Extension
    public static class DescriptorImpl
    extends GitHubHandlerDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Branch Handler";
        }
    }
}

