/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.multibranch.fs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jenkins.scm.api.SCMFile;
import org.apache.commons.io.IOUtils;
import org.kohsuke.github.GHContent;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHTree;
import org.kohsuke.github.GHTreeEntry;

public class TreeCache {
    private static final long CONTENT_THRESHOLD = 0x100000L;
    private final GHRepository repo;
    private final String revision;
    private final Map<String, Entry> entries = new HashMap<String, Entry>();
    private static final ThreadLocal<Context> CONTEXT = new ThreadLocal();

    private TreeCache(GHRepository repo, String revision) {
        this.repo = repo;
        this.revision = revision;
    }

    public Entry rootEntry() throws IOException {
        return this.entry("");
    }

    public Entry entry(String path) throws IOException {
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        Entry e = this.entries.get(path);
        if (e != null) {
            return e;
        }
        if (path.equals("")) {
            e = new Entry("", null, false);
            this.entries.put("", e);
            return e;
        }
        int idx = path.lastIndexOf(47);
        Entry parent = idx == -1 ? this.entry("") : this.entry(path.substring(0, idx));
        if (parent == Entry.NONE) {
            this.entries.put(path, parent);
            return parent;
        }
        if (parent.file) {
            this.entries.put(path, Entry.NONE);
            return Entry.NONE;
        }
        if (!parent.processed) {
            this.fillSubEntries(parent);
            e = this.entries.get(path);
        }
        if (e == null) {
            e = Entry.NONE;
        }
        this.entries.put(path, e);
        return e;
    }

    public InputStream content(Entry entry) throws IOException {
        return entry.load(this.repo, this.revision);
    }

    private void fillSubEntries(Entry e) throws IOException {
        Object dir;
        GHTree tree;
        if (e.entry == null) {
            tree = this.repo.getTree(this.revision);
            dir = "";
        } else {
            tree = e.entry.asTree();
            dir = e.path + "/";
        }
        ArrayList<String> subEntries = new ArrayList<String>();
        for (GHTreeEntry sub : tree.getTree()) {
            String newPath = (String)dir + sub.getPath();
            Entry ee = "tree".equals(sub.getType()) ? new Entry(newPath, sub) : new Entry(newPath, null);
            subEntries.add(sub.getPath());
            this.entries.put(newPath, ee);
        }
        e.subEntries = subEntries;
        e.processed = true;
    }

    public static TreeCache get(GHRepository repo, String revision) {
        Context ctx = CONTEXT.get();
        if (ctx != null) {
            return ctx.get(repo, revision);
        }
        return new TreeCache(repo, revision);
    }

    public static Context createContext() {
        return new Context();
    }

    public static class Entry {
        private static final Entry NONE = new Entry(null, null, false);
        private final String path;
        private final GHTreeEntry entry;
        private final boolean file;
        private final SCMFile.Type type;
        private List<String> subEntries;
        private boolean processed;
        private volatile byte[] cachedContent;

        public SCMFile.Type getType() {
            return this.type;
        }

        Entry(String path, GHTreeEntry entry) {
            this(path, entry, entry == null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        InputStream load(GHRepository repo, String revision) throws IOException {
            if (Objects.isNull(this.cachedContent)) {
                Entry entry = this;
                synchronized (entry) {
                    if (this.cachedContent == null) {
                        GHContent content = repo.getFileContent(this.path, revision);
                        long size = content.getSize();
                        if (size > 0x100000L) {
                            return content.read();
                        }
                        byte[] buf = new byte[(int)size];
                        try (InputStream in = content.read();){
                            IOUtils.readFully((InputStream)in, (byte[])buf);
                        }
                        this.cachedContent = buf;
                    }
                }
            }
            return new ByteArrayInputStream(this.cachedContent);
        }

        Entry(String path, GHTreeEntry entry, boolean file) {
            this.path = path;
            this.entry = entry;
            this.file = file;
            this.type = entry != null ? SCMFile.Type.DIRECTORY : (file ? SCMFile.Type.REGULAR_FILE : SCMFile.Type.NONEXISTENT);
        }

        public List<String> getSubEntryNames() {
            return this.subEntries;
        }
    }

    public static class Context
    implements AutoCloseable {
        private final boolean opened;
        private final Map<String, TreeCache> cache;

        public Context() {
            if (CONTEXT.get() != null) {
                this.opened = false;
            } else {
                this.opened = true;
                CONTEXT.set(this);
            }
            this.cache = new HashMap<String, TreeCache>();
        }

        public TreeCache get(GHRepository repo, String revision) {
            return this.cache.computeIfAbsent(this.key(repo, revision), k -> new TreeCache(repo, revision));
        }

        private String key(GHRepository repo, String revision) {
            return String.valueOf(repo.getHtmlUrl()) + "#" + revision;
        }

        @Override
        public void close() {
            if (this.opened) {
                this.cache.clear();
                CONTEXT.set(null);
            }
        }
    }
}

