/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.multibranch.fs;

import com.github.kostyasha.github.integration.multibranch.GitHubSCMSource;
import com.github.kostyasha.github.integration.multibranch.fs.TreeCache;
import com.github.kostyasha.github.integration.multibranch.head.GitHubSCMHead;
import com.github.kostyasha.github.integration.multibranch.revision.GitHubSCMRevision;
import java.io.IOException;
import jenkins.scm.api.SCMFile;
import jenkins.scm.api.SCMProbe;
import jenkins.scm.api.SCMProbeStat;
import org.kohsuke.github.GHCommit;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;

public class GitHubSCMProbe
extends SCMProbe {
    private static final long serialVersionUID = 1L;
    private final GitHubSCMSource source;
    private final GitHubSCMHead<?> head;
    private final GitHubSCMRevision revision;
    private volatile GHRepository repo;
    private volatile GHCommit commit;
    private volatile TreeCache tree;

    public GitHubSCMProbe(GitHubSCMSource source, GitHubSCMHead<?> head, GitHubSCMRevision revision) {
        this.source = source;
        this.head = head;
        this.revision = revision;
    }

    public GitHubSCMHead<?> getHead() {
        return this.head;
    }

    public GitHubSCMRevision getRevision() {
        return this.revision;
    }

    public String name() {
        return this.head.getName();
    }

    public void close() throws IOException {
    }

    public SCMProbeStat stat(String path) throws IOException {
        TreeCache.Entry e = this.tree().entry(path);
        return SCMProbeStat.fromType((SCMFile.Type)e.getType());
    }

    public long lastModified() {
        GHPullRequest pr;
        Object rd = this.revision.getRemoteData();
        if (rd instanceof GHPullRequest && (pr = (GHPullRequest)rd) != null) {
            try {
                return pr.getUpdatedAt().getTime();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            return this.commit().getCommitDate().getTime();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GHRepository repo() {
        if (this.repo == null) {
            GitHubSCMProbe gitHubSCMProbe = this;
            synchronized (gitHubSCMProbe) {
                if (this.repo == null) {
                    this.repo = this.source.getRepoProvider().getGHRepository(this.source);
                }
            }
        }
        return this.repo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GHCommit commit() throws IOException {
        if (this.commit == null) {
            GitHubSCMProbe gitHubSCMProbe = this;
            synchronized (gitHubSCMProbe) {
                if (this.commit == null) {
                    this.commit = this.repo().getCommit(this.revision.getHash());
                }
            }
        }
        return this.commit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeCache tree() {
        if (this.tree == null) {
            GitHubSCMProbe gitHubSCMProbe = this;
            synchronized (gitHubSCMProbe) {
                if (this.tree == null) {
                    this.tree = TreeCache.get(this.repo(), this.revision.getHash());
                }
            }
        }
        return this.tree;
    }
}

