/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.multibranch.fs;

import com.github.kostyasha.github.integration.multibranch.GitHubSCMSource;
import com.github.kostyasha.github.integration.multibranch.fs.GitHubSCMFileSystem;
import com.github.kostyasha.github.integration.multibranch.head.GitHubSCMHead;
import com.github.kostyasha.github.integration.multibranch.revision.GitHubSCMRevision;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import java.io.IOException;
import jenkins.scm.api.SCMFileSystem;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceDescriptor;
import org.kohsuke.github.GHRepository;

@Extension
public class GitHubSCMFileSystemBuilder
extends SCMFileSystem.Builder {
    public boolean supports(SCMSource source) {
        return source instanceof GitHubSCMSource;
    }

    protected boolean supportsDescriptor(SCMDescriptor descriptor) {
        return false;
    }

    protected boolean supportsDescriptor(SCMSourceDescriptor descriptor) {
        return descriptor instanceof GitHubSCMSource.DescriptorImpl;
    }

    public SCMFileSystem build(@NonNull SCMSource source, @NonNull SCMHead head, @CheckForNull SCMRevision rev) throws IOException, InterruptedException {
        if (source instanceof GitHubSCMSource) {
            GitHubSCMSource ghSCMSource = (GitHubSCMSource)source;
            GHRepository remoteRepo = ghSCMSource.getRemoteRepo();
            return new GitHubSCMFileSystem(remoteRepo, (GitHubSCMHead)head, (GitHubSCMRevision)rev);
        }
        return null;
    }

    public boolean supports(SCM source) {
        return false;
    }

    public SCMFileSystem build(@NonNull Item owner, @NonNull SCM scm, @CheckForNull SCMRevision rev) throws IOException, InterruptedException {
        return null;
    }
}

