/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.multibranch.fs;

import com.github.kostyasha.github.integration.multibranch.fs.GitHubSCMFile;
import com.github.kostyasha.github.integration.multibranch.fs.TreeCache;
import com.github.kostyasha.github.integration.multibranch.head.GitHubSCMHead;
import com.github.kostyasha.github.integration.multibranch.revision.GitHubSCMRevision;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import jenkins.scm.api.SCMFile;
import jenkins.scm.api.SCMFileSystem;
import jenkins.scm.api.SCMRevision;
import org.kohsuke.github.GHCommit;
import org.kohsuke.github.GHRepository;

public class GitHubSCMFileSystem
extends SCMFileSystem {
    private final GHRepository remoteRepo;
    private final GHCommit commit;
    private volatile TreeCache tree;

    protected GitHubSCMFileSystem(@NonNull GHRepository remoteRepo, GitHubSCMHead<?> head, GitHubSCMRevision rev) throws IOException {
        super((SCMRevision)rev);
        this.remoteRepo = remoteRepo;
        this.commit = remoteRepo.getCommit(GitHubSCMFileSystem.calculateHash(remoteRepo, head, rev));
    }

    private static String calculateHash(GHRepository remoteRepo, GitHubSCMHead<?> head, GitHubSCMRevision rev) throws IOException {
        if (rev != null) {
            return rev.getHash();
        }
        return head.fetchHeadSha(remoteRepo);
    }

    @NonNull
    public String getCommitSha() {
        return this.commit.getSHA1();
    }

    @NonNull
    public GHRepository getRemoteRepo() {
        return this.remoteRepo;
    }

    public long lastModified() throws IOException, InterruptedException {
        return this.commit.getCommitDate().getTime();
    }

    @NonNull
    public SCMFile getRoot() {
        return new GitHubSCMFile(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TreeCache tree() {
        if (this.tree == null) {
            GitHubSCMFileSystem gitHubSCMFileSystem = this;
            synchronized (gitHubSCMFileSystem) {
                if (this.tree == null) {
                    this.tree = TreeCache.get(this.remoteRepo, this.getCommitSha());
                }
            }
        }
        return this.tree;
    }
}

