/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.multibranch.fs;

import com.github.kostyasha.github.integration.multibranch.fs.GitHubSCMFileSystem;
import com.github.kostyasha.github.integration.multibranch.fs.TreeCache;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.util.stream.Collectors;
import jenkins.scm.api.SCMFile;

public class GitHubSCMFile
extends SCMFile {
    private final GitHubSCMFileSystem fs;
    private volatile TreeCache.Entry entry;

    public GitHubSCMFile(GitHubSCMFileSystem fs) {
        this.fs = fs;
    }

    public GitHubSCMFile(GitHubSCMFileSystem fs, GitHubSCMFile parent, String name) {
        super((SCMFile)parent, name);
        this.fs = fs;
    }

    public GitHubSCMFile(@NonNull GitHubSCMFile parent, String name) {
        super((SCMFile)parent, name);
        this.fs = parent.fs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeCache.Entry getEntry() throws IOException {
        if (this.entry == null) {
            GitHubSCMFile gitHubSCMFile = this;
            synchronized (gitHubSCMFile) {
                if (this.entry == null) {
                    this.entry = this.fs.tree().entry(this.getPath());
                }
            }
        }
        return this.entry;
    }

    private SCMFile newChild(@NonNull String child) {
        return new GitHubSCMFile(this, child);
    }

    @NonNull
    protected SCMFile newChild(@NonNull String child, boolean assumeIsDirectory) {
        return this.newChild(child);
    }

    @NonNull
    public Iterable<SCMFile> children() throws IOException, InterruptedException {
        return this.getEntry().getSubEntryNames().stream().map(this::newChild).collect(Collectors.toList());
    }

    public long lastModified() throws IOException, InterruptedException {
        return this.fs.lastModified();
    }

    @NonNull
    protected SCMFile.Type type() throws IOException, InterruptedException {
        return this.getEntry().getType();
    }

    @NonNull
    public InputStream content() throws IOException, InterruptedException {
        return this.fs.tree().content(this.getEntry());
    }
}

