/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.multibranch.action;

import com.github.kostyasha.github.integration.multibranch.action.GitHubLinkAction;
import com.github.kostyasha.github.integration.tag.GitHubTag;
import org.kohsuke.github.GHRepository;

public class GitHubTagAction
extends GitHubLinkAction {
    private String tag;

    public GitHubTagAction(GHRepository remoteRepository, String tag) {
        super(GitHubTagAction.buildUrl(remoteRepository, tag));
        this.tag = tag;
    }

    public String getDisplayName() {
        return "Tag " + this.tag;
    }

    @Override
    public String getIconFileName() {
        return GitHubTag.getIconFileName();
    }

    private static String buildUrl(GHRepository remoteRepository, String tag) {
        String repoUrl = remoteRepository.getHtmlUrl().toExternalForm();
        if (remoteRepository.getDefaultBranch().equals(tag)) {
            return repoUrl;
        }
        return repoUrl + "/releases/tag/" + tag;
    }
}

