/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.multibranch.action;

import com.github.kostyasha.github.integration.multibranch.action.GitHubRepo;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.BulkChange;
import hudson.XmlFile;
import hudson.model.PersistenceRoot;
import hudson.model.Saveable;
import hudson.model.listeners.SaveableListener;
import java.io.File;
import java.io.IOException;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubSCMSourcesLocalStorage
implements Saveable {
    private static final Logger LOG = LoggerFactory.getLogger(GitHubSCMSourcesLocalStorage.class);
    @NonNull
    protected transient PersistenceRoot project;
    private final String sourceId;
    private final GitHubRepo repoState;

    public GitHubSCMSourcesLocalStorage(@NonNull PersistenceRoot project, @NonNull String sourceId) {
        this.project = project;
        this.sourceId = sourceId;
        this.repoState = new GitHubRepo(this);
    }

    public GitHubRepo getLocalRepo() {
        return this.repoState;
    }

    public XmlFile getConfigFile() {
        return new XmlFile(new File(this.project.getRootDir(), "github-scm-" + this.normalizedSourceId() + ".xml"));
    }

    private String normalizedSourceId() {
        return DigestUtils.sha1Hex((String)this.sourceId);
    }

    public void saveQuietly() {
        try {
            this.save();
        }
        catch (IOException e) {
            LOG.error("Can't save repository state, because: '{}'", (Object)e.getMessage(), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        GitHubSCMSourcesLocalStorage gitHubSCMSourcesLocalStorage = this;
        synchronized (gitHubSCMSourcesLocalStorage) {
            if (BulkChange.contains((Saveable)this)) {
                return;
            }
            this.getConfigFile().write((Object)this);
        }
        SaveableListener.fireOnChange((Saveable)this, (XmlFile)this.getConfigFile());
    }

    public synchronized void load() throws IOException {
        if (this.getConfigFile().exists()) {
            this.getConfigFile().unmarshal((Object)this);
        }
        this.repoState.setOwner(this);
    }
}

