/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.multibranch.action;

import com.github.kostyasha.github.integration.branch.GitHubBranchRepository;
import com.github.kostyasha.github.integration.multibranch.action.GitHubSCMSourcesLocalStorage;
import com.github.kostyasha.github.integration.tag.GitHubTagRepository;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.Action;
import hudson.model.TaskListener;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRRepository;
import org.kohsuke.github.GHRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubRepo
implements Action {
    private static final Logger LOG = LoggerFactory.getLogger(GitHubRepo.class);
    private transient GitHubSCMSourcesLocalStorage owner;
    private GitHubBranchRepository branchRepository;
    private GitHubTagRepository tagRepository;
    private GitHubPRRepository prRepository;

    public GitHubRepo(GitHubSCMSourcesLocalStorage owner) {
        this.owner = owner;
    }

    public GitHubRepo(GHRepository repository) throws IOException {
        this(new GitHubBranchRepository(repository), new GitHubTagRepository(repository), new GitHubPRRepository(repository));
    }

    public GitHubRepo(String repoFullName, URL url) {
        this(new GitHubBranchRepository(repoFullName, url), new GitHubTagRepository(repoFullName, url), new GitHubPRRepository(repoFullName, url));
    }

    public GitHubRepo(GitHubBranchRepository branchRepository, GitHubTagRepository tagRepository, GitHubPRRepository prRepository) {
        this.branchRepository = branchRepository;
        this.tagRepository = tagRepository;
        this.prRepository = prRepository;
    }

    public GitHubBranchRepository getBranchRepository() {
        return this.branchRepository;
    }

    public GitHubTagRepository getTagRepository() {
        return this.tagRepository;
    }

    public GitHubPRRepository getPrRepository() {
        return this.prRepository;
    }

    @CheckForNull
    public String getIconFileName() {
        return null;
    }

    @CheckForNull
    public String getDisplayName() {
        return "GitHub Local State";
    }

    @CheckForNull
    public String getUrlName() {
        return null;
    }

    public void actualize(GHRepository remoteRepo) throws IOException {
        if (Objects.isNull(this.branchRepository)) {
            this.branchRepository = new GitHubBranchRepository(remoteRepo);
        } else {
            this.branchRepository.actualise(remoteRepo, TaskListener.NULL);
        }
        if (Objects.isNull(this.tagRepository)) {
            this.tagRepository = new GitHubTagRepository(remoteRepo);
        } else {
            this.tagRepository.actualise(remoteRepo, TaskListener.NULL);
        }
        if (Objects.isNull(this.prRepository)) {
            this.prRepository = new GitHubPRRepository(remoteRepo);
        } else {
            this.prRepository.actualise(remoteRepo, TaskListener.NULL);
        }
        if (this.owner != null) {
            this.owner.save();
        }
    }

    public void sync(GHRepository remoteRepo) {
    }

    public void setOwner(GitHubSCMSourcesLocalStorage owner) {
        this.owner = owner;
    }
}

