/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.multibranch;

import com.cloudbees.jenkins.GitHubRepositoryName;
import com.github.kostyasha.github.integration.generic.GitHubCause;
import com.github.kostyasha.github.integration.multibranch.GitHubParametersAction;
import com.github.kostyasha.github.integration.multibranch.action.GitHubBranchAction;
import com.github.kostyasha.github.integration.multibranch.action.GitHubLinkAction;
import com.github.kostyasha.github.integration.multibranch.action.GitHubPRAction;
import com.github.kostyasha.github.integration.multibranch.action.GitHubRepo;
import com.github.kostyasha.github.integration.multibranch.action.GitHubRepoAction;
import com.github.kostyasha.github.integration.multibranch.action.GitHubSCMSourcesLocalStorage;
import com.github.kostyasha.github.integration.multibranch.action.GitHubTagAction;
import com.github.kostyasha.github.integration.multibranch.category.GitHubBranchSCMHeadCategory;
import com.github.kostyasha.github.integration.multibranch.category.GitHubPRSCMHeadCategory;
import com.github.kostyasha.github.integration.multibranch.category.GitHubTagSCMHeadCategory;
import com.github.kostyasha.github.integration.multibranch.fs.GitHubSCMProbe;
import com.github.kostyasha.github.integration.multibranch.fs.TreeCache;
import com.github.kostyasha.github.integration.multibranch.handler.GitHubHandler;
import com.github.kostyasha.github.integration.multibranch.handler.GitHubSourceContext;
import com.github.kostyasha.github.integration.multibranch.head.GitHubBranchSCMHead;
import com.github.kostyasha.github.integration.multibranch.head.GitHubPRSCMHead;
import com.github.kostyasha.github.integration.multibranch.head.GitHubSCMHead;
import com.github.kostyasha.github.integration.multibranch.head.GitHubTagSCMHead;
import com.github.kostyasha.github.integration.multibranch.repoprovider.GitHubRepoProvider2;
import com.github.kostyasha.github.integration.multibranch.revision.GitHubSCMRevision;
import com.github.kostyasha.github.integration.multibranch.scm.GitHubSCMFactory;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.BulkChange;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.ParameterValue;
import hudson.model.PersistenceRoot;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.scm.SCM;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadCategory;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMProbe;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.api.SCMSourceEvent;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.metadata.ObjectMetadataAction;
import jenkins.scm.api.metadata.PrimaryInstanceMetadataAction;
import org.jenkinsci.Symbol;
import org.kohsuke.github.GHRepository;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubSCMSource
extends SCMSource {
    private static final Logger LOG = LoggerFactory.getLogger(GitHubSCMSource.class);
    private String projectUrlStr;
    private GitHubRepoProvider2 repoProvider = null;
    private List<GitHubHandler> handlers = new ArrayList<GitHubHandler>();
    private GitHubSCMFactory scmFactory;
    private volatile transient GitHubSCMSourcesLocalStorage localStorage;

    @DataBoundConstructor
    public GitHubSCMSource() {
    }

    public GitHubRepositoryName getRepoFullName() {
        return GitHubRepositoryName.create((String)this.projectUrlStr);
    }

    @DataBoundSetter
    public void setProjectUrlStr(String projectUrlStr) {
        this.projectUrlStr = projectUrlStr;
    }

    public String getProjectUrlStr() {
        return this.projectUrlStr;
    }

    @CheckForNull
    public GitHubRepoProvider2 getRepoProvider() {
        return this.repoProvider;
    }

    @DataBoundSetter
    public GitHubSCMSource setRepoProvider(GitHubRepoProvider2 repoProvider) {
        this.repoProvider = repoProvider;
        return this;
    }

    public List<GitHubHandler> getHandlers() {
        return this.handlers;
    }

    @DataBoundSetter
    public GitHubSCMSource setHandlers(List<GitHubHandler> handlers) {
        this.handlers = handlers;
        return this;
    }

    public GitHubSCMFactory getScmFactory() {
        return this.scmFactory;
    }

    @DataBoundSetter
    public GitHubSCMSource setScmFactory(GitHubSCMFactory scmFactory) {
        this.scmFactory = scmFactory;
        return this;
    }

    public GitHubRepo getLocalRepo() {
        return this.getLocalStorage().getLocalRepo();
    }

    protected synchronized GitHubSCMSourcesLocalStorage getLocalStorage() {
        if (Objects.isNull(this.localStorage)) {
            this.localStorage = new GitHubSCMSourcesLocalStorage((PersistenceRoot)this.getOwner(), this.getId());
            try {
                this.localStorage.load();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.localStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void retrieve(SCMSourceCriteria scmSourceCriteria, @NonNull SCMHeadObserver scmHeadObserver, SCMHeadEvent<?> scmHeadEvent, @NonNull TaskListener taskListener) throws IOException, InterruptedException {
        try (BulkChange bc = new BulkChange((Saveable)this.getLocalStorage());
             TreeCache.Context ctx = TreeCache.createContext();){
            GitHubRepo localRepo;
            GitHubRepo gitHubRepo = localRepo = this.getLocalRepo();
            synchronized (gitHubRepo) {
                localRepo.actualize(this.getRemoteRepo());
                GitHubSourceContext context = new GitHubSourceContext(this, scmHeadObserver, scmSourceCriteria, scmHeadEvent, localRepo, this.getRemoteRepo(), taskListener);
                this.getHandlers().forEach(handler -> {
                    try {
                        handler.handle(context);
                    }
                    catch (Throwable e) {
                        LOG.error("Can't process handler", e);
                        e.printStackTrace(taskListener.getLogger());
                    }
                });
            }
            bc.commit();
        }
    }

    public void afterSave() {
        SCMSourceOwner owner = this.getOwner();
        if (Objects.nonNull(owner) && this.getRepoProvider().isManageHooks(this)) {
            this.getRepoProvider().registerHookFor(this);
        }
    }

    @NonNull
    public GHRepository getRemoteRepo() throws IOException {
        Objects.requireNonNull(this.repoProvider);
        GHRepository remoteRepository = this.repoProvider.getGHRepository(this);
        Preconditions.checkState((boolean)Objects.nonNull(remoteRepository), (String)"Can't get remote GH repo for source %s", (Object)this.getId());
        return remoteRepository;
    }

    @NonNull
    public SCM build(@NonNull SCMHead scmHead, SCMRevision scmRevision) {
        return this.scmFactory.createScm(this, scmHead, scmRevision);
    }

    @NonNull
    public Set<SCMRevision> parentRevisions(@NonNull SCMHead head, @NonNull SCMRevision revision, @CheckForNull TaskListener listener) throws IOException, InterruptedException {
        return super.parentRevisions(head, revision, listener);
    }

    @NonNull
    public Map<SCMHead, SCMRevision> parentHeads(@NonNull SCMHead head, @CheckForNull TaskListener listener) throws IOException, InterruptedException {
        return super.parentHeads(head, listener);
    }

    @NonNull
    protected Set<SCMHead> retrieve(@NonNull TaskListener listener) throws IOException, InterruptedException {
        return super.retrieve(listener);
    }

    @NonNull
    protected Set<SCMHead> retrieve(@CheckForNull SCMSourceCriteria criteria, @NonNull TaskListener listener) throws IOException, InterruptedException {
        return super.retrieve(criteria, listener);
    }

    protected SCMRevision retrieve(@NonNull SCMHead head, @NonNull TaskListener listener) throws IOException, InterruptedException {
        return super.retrieve(head, listener);
    }

    protected SCMRevision retrieve(@NonNull String thingName, @NonNull TaskListener listener) throws IOException, InterruptedException {
        return super.retrieve(thingName, listener);
    }

    @NonNull
    protected Set<String> retrieveRevisions(@NonNull TaskListener listener) throws IOException, InterruptedException {
        return super.retrieveRevisions(listener);
    }

    @NonNull
    protected List<Action> retrieveActions(@NonNull SCMRevision revision, @CheckForNull SCMHeadEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        GitHubSCMRevision gitHubSCMRevision = (GitHubSCMRevision)revision;
        GitHubCause cause = gitHubSCMRevision.getCause();
        if (Objects.nonNull((Object)cause)) {
            ArrayList<ParameterValue> params = new ArrayList<ParameterValue>();
            cause.fillParameters(params);
            return Arrays.asList(new Action[]{new CauseAction((Cause)cause), new GitHubParametersAction(params)});
        }
        return Collections.emptyList();
    }

    @NonNull
    protected List<Action> retrieveActions(@NonNull SCMHead head, @CheckForNull SCMHeadEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        ArrayList<Action> actions = new ArrayList<Action>();
        GHRepository remoteRepo = this.getRemoteRepo();
        boolean primary = false;
        GitHubLinkAction link = null;
        String desc = null;
        if (head instanceof GitHubBranchSCMHead) {
            primary = remoteRepo.getDefaultBranch().equals(head.getName());
            link = new GitHubBranchAction(remoteRepo, head.getName());
            desc = null;
        } else if (head instanceof GitHubTagSCMHead) {
            link = new GitHubTagAction(remoteRepo, head.getName());
            desc = null;
        } else if (head instanceof GitHubPRSCMHead) {
            GitHubPRSCMHead prHead = (GitHubPRSCMHead)head;
            link = new GitHubPRAction(remoteRepo, prHead.getPrNumber());
            desc = remoteRepo.getPullRequest(prHead.getPrNumber()).getTitle();
        }
        if (Objects.nonNull(link)) {
            actions.add(link);
        }
        actions.add((Action)new ObjectMetadataAction(null, desc, Objects.isNull(link) ? null : link.getUrlName()));
        if (primary) {
            actions.add((Action)new PrimaryInstanceMetadataAction());
        }
        return actions;
    }

    @NonNull
    protected List<Action> retrieveActions(@CheckForNull SCMSourceEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        return Collections.singletonList(new GitHubRepoAction(this.getRemoteRepo()));
    }

    @NonNull
    public SCMRevision getTrustedRevision(@NonNull SCMRevision revision, @NonNull TaskListener listener) throws IOException, InterruptedException {
        return super.getTrustedRevision(revision, listener);
    }

    public boolean canProbe() {
        return true;
    }

    @NonNull
    protected SCMProbe createProbe(@NonNull SCMHead head, @CheckForNull SCMRevision revision) throws IOException {
        return new GitHubSCMProbe(this, (GitHubSCMHead)head, (GitHubSCMRevision)revision);
    }

    protected boolean isCategoryEnabled(@NonNull SCMHeadCategory category) {
        return true;
    }

    @Symbol(value={"gitHub"})
    @Extension
    public static class DescriptorImpl
    extends SCMSourceDescriptor {
        @NonNull
        protected SCMHeadCategory[] createCategories() {
            return new SCMHeadCategory[]{GitHubBranchSCMHeadCategory.BRANCH, GitHubPRSCMHeadCategory.PR, GitHubTagSCMHeadCategory.TAG};
        }

        @NonNull
        public String getDisplayName() {
            return "GitHub source";
        }

        public List<GitHubSCMFactory.GitHubSCMFactoryDescriptor> getScmFactoryDescriptors() {
            return ExtensionList.lookup(GitHubSCMFactory.GitHubSCMFactoryDescriptor.class);
        }
    }
}

